/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types;

import java.util.Iterator;
import java.util.List;
import org.apache.crunch.GroupingOptions;
import org.apache.crunch.MapFn;
import org.apache.crunch.Pair;
import org.apache.crunch.io.ReadableSourceTarget;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public abstract class PGroupedTableType<K, V>
implements PType<Pair<K, Iterable<V>>> {
    protected final PTableType<K, V> tableType;

    public PGroupedTableType(PTableType<K, V> tableType) {
        this.tableType = tableType;
    }

    public PTableType<K, V> getTableType() {
        return this.tableType;
    }

    @Override
    public PTypeFamily getFamily() {
        return this.tableType.getFamily();
    }

    @Override
    public List<PType> getSubTypes() {
        return this.tableType.getSubTypes();
    }

    @Override
    public Converter getConverter() {
        return this.tableType.getConverter();
    }

    public abstract Converter getGroupingConverter();

    public abstract void configureShuffle(Job var1, GroupingOptions var2);

    @Override
    public ReadableSourceTarget<Pair<K, Iterable<V>>> getDefaultFileSource(Path path) {
        throw new UnsupportedOperationException("Grouped tables cannot be written out directly");
    }

    public static class PairIterableMapFn<K, V>
    extends MapFn<Pair<Object, Iterable<Object>>, Pair<K, Iterable<V>>> {
        private final MapFn<Object, K> keys;
        private final MapFn<Object, V> values;

        public PairIterableMapFn(MapFn<Object, K> keys, MapFn<Object, V> values) {
            this.keys = keys;
            this.values = values;
        }

        @Override
        public void configure(Configuration conf) {
            this.keys.configure(conf);
            this.values.configure(conf);
        }

        @Override
        public void setContext(TaskInputOutputContext<?, ?, ?, ?> context) {
            this.keys.setContext(context);
            this.values.setContext(context);
        }

        @Override
        public void initialize() {
            this.keys.initialize();
            this.values.initialize();
        }

        @Override
        public Pair<K, Iterable<V>> map(Pair<Object, Iterable<Object>> input) {
            return Pair.of(this.keys.map(input.first()), new PTypeIterable<V>(this.values, input.second()));
        }
    }

    protected static class HoldLastIterator<V>
    implements Iterator<V> {
        private Iterator<Object> iter;
        private V lastReturned = null;
        private final MapFn<Object, V> mapFn;

        public HoldLastIterator(MapFn<Object, V> mapFn) {
            this.mapFn = mapFn;
        }

        public HoldLastIterator<V> reset(Iterator<Object> iter) {
            this.iter = iter;
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        @Override
        public V next() {
            this.lastReturned = this.mapFn.map(this.iter.next());
            return this.lastReturned;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder().append('[');
            if (this.lastReturned != null) {
                sb.append(this.lastReturned).append(", ...]");
            } else if (this.iter != null) {
                sb.append("...]");
            }
            return sb.toString();
        }
    }

    protected static class PTypeIterable<V>
    implements Iterable<V> {
        private final Iterable<Object> iterable;
        private final HoldLastIterator<V> holdLastIter;

        public PTypeIterable(MapFn<Object, V> mapFn, Iterable<Object> iterable) {
            this.iterable = iterable;
            this.holdLastIter = new HoldLastIterator<V>(mapFn);
        }

        @Override
        public Iterator<V> iterator() {
            return this.holdLastIter.reset(this.iterable.iterator());
        }

        public String toString() {
            return this.holdLastIter.toString();
        }
    }
}

