/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.types;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.crunch.types.DeepCopier;
import org.apache.crunch.types.PType;
import org.apache.hadoop.conf.Configuration;

public class CollectionDeepCopier<T>
implements DeepCopier<Collection<T>> {
    private PType<T> elementType;

    public CollectionDeepCopier(PType<T> elementType) {
        this.elementType = elementType;
    }

    @Override
    public void initialize(Configuration conf) {
        this.elementType.initialize(conf);
    }

    @Override
    public Collection<T> deepCopy(Collection<T> source) {
        if (source == null) {
            return null;
        }
        ArrayList copiedCollection = Lists.newArrayListWithCapacity((int)source.size());
        for (T value : source) {
            copiedCollection.add(this.elementType.getDetachedValue(value));
        }
        return copiedCollection;
    }
}

