/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.lib.sort;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import org.apache.avro.Schema;
import org.apache.avro.mapred.AvroKey;
import org.apache.crunch.io.CompositePathIterable;
import org.apache.crunch.io.avro.AvroFileReaderFactory;
import org.apache.crunch.io.seq.SeqFileReaderFactory;
import org.apache.crunch.types.writable.WritableDeepCopier;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Partitioner;

public class TotalOrderPartitioner<K, V>
extends Partitioner<K, V>
implements Configurable {
    public static final String DEFAULT_PATH = "_partition.lst";
    public static final String PARTITIONER_PATH = "crunch.totalorderpartitioner.path";
    private Configuration conf;
    private Node<K> partitions;

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        try {
            this.conf = conf;
            String parts = TotalOrderPartitioner.getPartitionFile(conf);
            Path partFile = new Path(parts);
            LocalFileSystem fs = DEFAULT_PATH.equals(parts) ? FileSystem.getLocal((Configuration)conf) : partFile.getFileSystem(conf);
            Job job = new Job(conf);
            Class keyClass = job.getMapOutputKeyClass();
            RawComparator comparator = job.getSortComparator();
            K[] splitPoints = this.readPartitions((FileSystem)fs, partFile, keyClass, conf, comparator);
            int numReduceTasks = job.getNumReduceTasks();
            if (splitPoints.length != numReduceTasks - 1) {
                throw new IOException("Wrong number of partitions in keyset");
            }
            this.partitions = new BinarySearchNode(splitPoints, comparator);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read partitions file", e);
        }
    }

    public int getPartition(K key, V value, int modulo) {
        return this.partitions.findPartition(key);
    }

    public static void setPartitionFile(Configuration conf, Path p) {
        conf.set(PARTITIONER_PATH, p.toString());
    }

    public static String getPartitionFile(Configuration conf) {
        return conf.get(PARTITIONER_PATH, DEFAULT_PATH);
    }

    private K[] readPartitions(FileSystem fs, Path p, Class<K> keyClass, Configuration conf, RawComparator<K> comparator) throws IOException {
        ArrayList<Object> parts = new ArrayList<Object>();
        String schema = conf.get("crunch.schema");
        if (schema != null) {
            Schema s = new Schema.Parser().parse(schema);
            AvroFileReaderFactory a = new AvroFileReaderFactory(s);
            Iterator iter = CompositePathIterable.create(fs, p, a).iterator();
            while (iter.hasNext()) {
                parts.add(new AvroKey(iter.next()));
            }
        } else {
            WritableDeepCopier<K> wdc = new WritableDeepCopier<K>(keyClass);
            SeqFileReaderFactory s = new SeqFileReaderFactory(keyClass);
            Iterator iter = CompositePathIterable.create(fs, p, s).iterator();
            while (iter.hasNext()) {
                parts.add(wdc.deepCopy((K)((Writable)iter.next())));
            }
        }
        Collections.sort(parts, comparator);
        return parts.toArray((Object[])Array.newInstance(keyClass, parts.size()));
    }

    class BinarySearchNode
    implements Node<K> {
        private final K[] splitPoints;
        private final RawComparator<K> comparator;

        BinarySearchNode(K[] splitPoints, RawComparator<K> comparator) {
            this.splitPoints = splitPoints;
            this.comparator = comparator;
        }

        @Override
        public int findPartition(K key) {
            int pos = Arrays.binarySearch(this.splitPoints, key, this.comparator) + 1;
            return pos < 0 ? -pos : pos;
        }
    }

    static interface Node<T> {
        public int findPartition(T var1);
    }
}

