/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.lib.sort;

import org.apache.avro.Schema;
import org.apache.avro.io.BinaryData;
import org.apache.avro.mapred.AvroKey;
import org.apache.crunch.types.avro.AvroMode;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.RawComparator;

public class ReverseAvroComparator<T>
extends Configured
implements RawComparator<AvroKey<T>> {
    private Schema schema;
    private AvroMode mode;

    public void setConf(Configuration conf) {
        super.setConf(conf);
        if (conf != null) {
            this.schema = new Schema.Parser().parse(conf.get("crunch.schema"));
            this.mode = AvroMode.fromShuffleConfiguration(conf);
        }
    }

    public int compare(AvroKey<T> o1, AvroKey<T> o2) {
        return this.mode.getData().compare(o2.datum(), o1.datum(), this.schema);
    }

    public int compare(byte[] arg0, int arg1, int arg2, byte[] arg3, int arg4, int arg5) {
        return BinaryData.compare((byte[])arg3, (int)arg4, (int)arg5, (byte[])arg0, (int)arg1, (int)arg2, (Schema)this.schema);
    }
}

