/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.lib.join;

import java.io.DataInput;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryData;
import org.apache.avro.mapred.AvroJob;
import org.apache.avro.mapred.AvroWrapper;
import org.apache.avro.mapred.Pair;
import org.apache.crunch.types.PTypeFamily;
import org.apache.crunch.types.avro.AvroMode;
import org.apache.crunch.types.writable.TupleWritable;
import org.apache.crunch.types.writable.WritableTypeFamily;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.DataInputBuffer;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.Partitioner;

public class JoinUtils {
    public static Class<? extends Partitioner> getPartitionerClass(PTypeFamily typeFamily) {
        if (typeFamily == WritableTypeFamily.getInstance()) {
            return TupleWritablePartitioner.class;
        }
        return AvroIndexedRecordPartitioner.class;
    }

    public static Class<? extends RawComparator> getGroupingComparator(PTypeFamily typeFamily) {
        if (typeFamily == WritableTypeFamily.getInstance()) {
            return TupleWritableComparator.class;
        }
        return AvroPairGroupingComparator.class;
    }

    public static class AvroPairGroupingComparator<T>
    extends Configured
    implements RawComparator<AvroWrapper<T>> {
        private Schema schema;
        private AvroMode mode;

        public void setConf(Configuration conf) {
            super.setConf(conf);
            if (conf != null) {
                Schema mapOutputSchema = AvroJob.getMapOutputSchema((Configuration)conf);
                Schema keySchema = Pair.getKeySchema((Schema)mapOutputSchema);
                this.schema = ((Schema.Field)keySchema.getFields().get(0)).schema();
                this.mode = AvroMode.fromShuffleConfiguration(conf);
            }
        }

        public int compare(AvroWrapper<T> x, AvroWrapper<T> y) {
            return this.mode.getData().compare(x.datum(), y.datum(), this.schema);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return BinaryData.compare((byte[])b1, (int)s1, (int)l1, (byte[])b2, (int)s2, (int)l2, (Schema)this.schema);
        }
    }

    public static class AvroIndexedRecordPartitioner
    extends Partitioner<Object, Object> {
        public int getPartition(Object key, Object value, int numPartitions) {
            IndexedRecord record;
            if (key instanceof AvroWrapper) {
                record = (IndexedRecord)((AvroWrapper)key).datum();
            } else if (key instanceof IndexedRecord) {
                record = (IndexedRecord)key;
            } else {
                throw new UnsupportedOperationException("Unknown avro key type: " + key);
            }
            return (record.get(0).hashCode() & Integer.MAX_VALUE) % numPartitions;
        }
    }

    public static class TupleWritableComparator
    implements RawComparator<TupleWritable> {
        private DataInputBuffer buffer = new DataInputBuffer();
        private TupleWritable key1 = new TupleWritable();
        private TupleWritable key2 = new TupleWritable();

        public int compare(TupleWritable o1, TupleWritable o2) {
            return ((Comparable)o1.get(0)).compareTo(o2.get(0));
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            try {
                this.buffer.reset(b1, s1, l1);
                this.key1.readFields((DataInput)this.buffer);
                this.buffer.reset(b2, s2, l2);
                this.key2.readFields((DataInput)this.buffer);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this.compare(this.key1, this.key2);
        }
    }

    public static class TupleWritablePartitioner
    extends Partitioner<TupleWritable, Writable> {
        public int getPartition(TupleWritable key, Writable value, int numPartitions) {
            return (key.get(0).hashCode() & Integer.MAX_VALUE) % numPartitions;
        }
    }
}

