/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.lib;

import org.apache.avro.Schema;
import org.apache.crunch.DoFn;
import org.apache.crunch.Emitter;
import org.apache.crunch.GroupingOptions;
import org.apache.crunch.PCollection;
import org.apache.crunch.PTable;
import org.apache.crunch.Pair;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.Tuple;
import org.apache.crunch.Tuple3;
import org.apache.crunch.Tuple4;
import org.apache.crunch.lib.Sample;
import org.apache.crunch.lib.sort.ReverseAvroComparator;
import org.apache.crunch.lib.sort.ReverseWritableComparator;
import org.apache.crunch.lib.sort.SortFns;
import org.apache.crunch.lib.sort.TotalOrderPartitioner;
import org.apache.crunch.lib.sort.TupleWritableComparator;
import org.apache.crunch.materialize.MaterializableIterable;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.AvroTypeFamily;
import org.apache.crunch.types.writable.WritableType;
import org.apache.crunch.types.writable.WritableTypeFamily;
import org.apache.crunch.util.PartitionUtils;
import org.apache.hadoop.conf.Configuration;

public class Sort {
    public static <T> PCollection<T> sort(PCollection<T> collection) {
        return Sort.sort(collection, Order.ASCENDING);
    }

    public static <T> PCollection<T> sort(PCollection<T> collection, Order order) {
        return Sort.sort(collection, -1, order);
    }

    public static <T> PCollection<T> sort(PCollection<T> collection, int numReducers, Order order) {
        PTypeFamily tf = collection.getTypeFamily();
        PTableType<T, Void> type = tf.tableOf(collection.getPType(), tf.nulls());
        Configuration conf = collection.getPipeline().getConfiguration();
        PTable<T, Void> pt = collection.parallelDo("sort-pre", new DoFn<T, Pair<T, Void>>(){

            @Override
            public void process(T input, Emitter<Pair<T, Void>> emitter) {
                emitter.emit(Pair.of(input, null));
            }
        }, type);
        GroupingOptions options = Sort.buildGroupingOptions(pt, conf, numReducers, order);
        return pt.groupByKey(options).ungroup().keys();
    }

    public static <K, V> PTable<K, V> sort(PTable<K, V> table) {
        return Sort.sort(table, Order.ASCENDING);
    }

    public static <K, V> PTable<K, V> sort(PTable<K, V> table, Order key) {
        return Sort.sort(table, -1, key);
    }

    public static <K, V> PTable<K, V> sort(PTable<K, V> table, int numReducers, Order key) {
        Configuration conf = table.getPipeline().getConfiguration();
        GroupingOptions options = Sort.buildGroupingOptions(table, conf, numReducers, key);
        return table.groupByKey(options).ungroup();
    }

    public static <U, V> PCollection<Pair<U, V>> sortPairs(PCollection<Pair<U, V>> collection, ColumnOrder ... columnOrders) {
        return Sort.sortTuples(collection, columnOrders);
    }

    public static <V1, V2, V3> PCollection<Tuple3<V1, V2, V3>> sortTriples(PCollection<Tuple3<V1, V2, V3>> collection, ColumnOrder ... columnOrders) {
        return Sort.sortTuples(collection, columnOrders);
    }

    public static <V1, V2, V3, V4> PCollection<Tuple4<V1, V2, V3, V4>> sortQuads(PCollection<Tuple4<V1, V2, V3, V4>> collection, ColumnOrder ... columnOrders) {
        return Sort.sortTuples(collection, columnOrders);
    }

    public static <T extends Tuple> PCollection<T> sortTuples(PCollection<T> collection, ColumnOrder ... columnOrders) {
        return Sort.sortTuples(collection, -1, columnOrders);
    }

    public static <T extends Tuple> PCollection<T> sortTuples(PCollection<T> collection, int numReducers, ColumnOrder ... columnOrders) {
        PType<T> pType = collection.getPType();
        SortFns.KeyExtraction<T> ke = new SortFns.KeyExtraction<T>(pType, columnOrders);
        PTable<Object, T> pt = collection.by(ke.getByFn(), ke.getKeyType());
        Configuration conf = collection.getPipeline().getConfiguration();
        GroupingOptions options = Sort.buildGroupingOptions(pt, conf, numReducers, columnOrders);
        return pt.groupByKey(options).ungroup().values();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static <K, V> GroupingOptions buildGroupingOptions(PTable<K, V> ptable, Configuration conf, int numReducers, Order order) {
        PType<K> ptype = ptable.getKeyType();
        PTypeFamily tf = ptable.getTypeFamily();
        GroupingOptions.Builder builder = GroupingOptions.builder();
        if (order == Order.DESCENDING) {
            if (tf == WritableTypeFamily.getInstance()) {
                builder.sortComparatorClass(ReverseWritableComparator.class);
            } else {
                if (tf != AvroTypeFamily.getInstance()) throw new RuntimeException("Unrecognized type family: " + tf);
                AvroType avroType = (AvroType)ptype;
                Schema schema = avroType.getSchema();
                builder.conf("crunch.schema", schema.toString());
                builder.sortComparatorClass(ReverseAvroComparator.class);
            }
        } else if (tf == AvroTypeFamily.getInstance()) {
            builder.conf("crunch.schema", ((AvroType)ptype).getSchema().toString());
        }
        builder.requireSortedKeys();
        Sort.configureReducers(builder, ptable, conf, numReducers);
        return builder.build();
    }

    private static <K, V> GroupingOptions buildGroupingOptions(PTable<K, V> ptable, Configuration conf, int numReducers, ColumnOrder[] columnOrders) {
        PTypeFamily tf = ptable.getTypeFamily();
        PType<K> keyType = ptable.getKeyType();
        GroupingOptions.Builder builder = GroupingOptions.builder();
        if (tf == WritableTypeFamily.getInstance()) {
            if (columnOrders.length == 1 && columnOrders[0].order == Order.DESCENDING) {
                builder.sortComparatorClass(ReverseWritableComparator.class);
            } else {
                WritableType[] wt = new WritableType[columnOrders.length];
                for (int i = 0; i < wt.length; ++i) {
                    wt[i] = (WritableType)keyType.getSubTypes().get(i);
                }
                TupleWritableComparator.configureOrdering(conf, wt, columnOrders);
                builder.sortComparatorClass(TupleWritableComparator.class);
            }
        } else if (tf == AvroTypeFamily.getInstance()) {
            AvroType avroType = (AvroType)keyType;
            Schema schema = avroType.getSchema();
            builder.conf("crunch.schema", schema.toString());
            if (columnOrders.length == 1 && columnOrders[0].order == Order.DESCENDING) {
                builder.sortComparatorClass(ReverseAvroComparator.class);
            }
        } else {
            throw new RuntimeException("Unrecognized type family: " + tf);
        }
        builder.requireSortedKeys();
        Sort.configureReducers(builder, ptable, conf, numReducers);
        return builder.build();
    }

    private static <K, V> void configureReducers(GroupingOptions.Builder builder, PTable<K, V> ptable, Configuration conf, int numReducers) {
        if (numReducers <= 0 && (numReducers = PartitionUtils.getRecommendedPartitions(ptable, conf)) < 5) {
            numReducers = 1;
        }
        builder.numReducers(numReducers);
        if (numReducers > 1) {
            Iterable<K> iter = Sample.reservoirSample(ptable.keys(), numReducers - 1).materialize();
            MaterializableIterable mi = (MaterializableIterable)iter;
            if (mi.isSourceTarget()) {
                builder.sourceTargets((SourceTarget)((Object)mi.getSource()));
            }
            builder.partitionerClass(TotalOrderPartitioner.class);
            builder.conf("crunch.totalorderpartitioner.path", mi.getPath().toString());
        }
    }

    public static class ColumnOrder {
        private int column;
        private Order order;

        public ColumnOrder(int column, Order order) {
            this.column = column;
            this.order = order;
        }

        public static ColumnOrder by(int column, Order order) {
            return new ColumnOrder(column, order);
        }

        public int column() {
            return this.column;
        }

        public Order order() {
            return this.order;
        }

        public String toString() {
            return "ColumnOrder: column:" + this.column + ", Order: " + (Object)((Object)this.order);
        }
    }

    public static enum Order {
        ASCENDING,
        DESCENDING,
        IGNORE;

    }
}

