/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.lib;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import org.apache.crunch.CombineFn;
import org.apache.crunch.DoFn;
import org.apache.crunch.Emitter;
import org.apache.crunch.FilterFn;
import org.apache.crunch.Pair;
import org.apache.crunch.types.PType;

final class SampleUtils {
    SampleUtils() {
    }

    static class WRSCombineFn<T>
    extends CombineFn<Integer, Pair<Double, T>> {
        private final int[] sampleSizes;
        private final PType<T> valueType;
        private List<SortedMap<Double, T>> reservoirs;

        WRSCombineFn(int[] sampleSizes, PType<T> valueType) {
            this.sampleSizes = sampleSizes;
            this.valueType = valueType;
        }

        @Override
        public void initialize() {
            this.reservoirs = Lists.newArrayList();
            for (int sampleSize : this.sampleSizes) {
                this.reservoirs.add(Maps.newTreeMap());
            }
            this.valueType.initialize(this.getConfiguration());
        }

        @Override
        public void process(Pair<Integer, Iterable<Pair<Double, T>>> input, Emitter<Pair<Integer, Pair<Double, T>>> emitter) {
            SortedMap<Double, T> reservoir = this.reservoirs.get(input.first());
            for (Pair<Double, T> p : input.second()) {
                if (reservoir.size() < this.sampleSizes[input.first()]) {
                    reservoir.put(p.first(), this.valueType.getDetachedValue(p.second()));
                    continue;
                }
                if (!(p.first() > reservoir.firstKey())) continue;
                reservoir.remove(reservoir.firstKey());
                reservoir.put(p.first(), this.valueType.getDetachedValue(p.second()));
            }
        }

        @Override
        public void cleanup(Emitter<Pair<Integer, Pair<Double, T>>> emitter) {
            for (int i = 0; i < this.reservoirs.size(); ++i) {
                Map reservoir = this.reservoirs.get(i);
                for (Map.Entry e : reservoir.entrySet()) {
                    emitter.emit(Pair.of(i, Pair.of(e.getKey(), e.getValue())));
                }
            }
        }
    }

    static class ReservoirSampleFn<T, N extends Number>
    extends DoFn<Pair<Integer, Pair<T, N>>, Pair<Integer, Pair<Double, T>>> {
        private final int[] sampleSizes;
        private final Long seed;
        private final PType<T> valueType;
        private transient List<SortedMap<Double, T>> reservoirs;
        private transient Random random;

        ReservoirSampleFn(int[] sampleSizes, Long seed, PType<T> valueType) {
            this.sampleSizes = sampleSizes;
            this.seed = seed;
            this.valueType = valueType;
        }

        @Override
        public void initialize() {
            this.reservoirs = Lists.newArrayList();
            this.valueType.initialize(this.getConfiguration());
            for (int sampleSize : this.sampleSizes) {
                this.reservoirs.add(Maps.newTreeMap());
            }
            if (this.random == null) {
                this.random = this.seed == null ? new Random() : new Random(this.seed);
            }
        }

        @Override
        public void process(Pair<Integer, Pair<T, N>> input, Emitter<Pair<Integer, Pair<Double, T>>> emitter) {
            int id = input.first();
            Pair<T, N> p = input.second();
            double weight = ((Number)p.second()).doubleValue();
            if (weight > 0.0) {
                double score = Math.log(this.random.nextDouble()) / weight;
                SortedMap<Double, T> reservoir = this.reservoirs.get(id);
                if (reservoir.size() < this.sampleSizes[id]) {
                    reservoir.put(score, this.valueType.getDetachedValue(p.first()));
                } else if (score > reservoir.firstKey()) {
                    reservoir.remove(reservoir.firstKey());
                    reservoir.put(score, this.valueType.getDetachedValue(p.first()));
                }
            }
        }

        @Override
        public void cleanup(Emitter<Pair<Integer, Pair<Double, T>>> emitter) {
            for (int id = 0; id < this.reservoirs.size(); ++id) {
                Map reservoir = this.reservoirs.get(id);
                for (Map.Entry e : reservoir.entrySet()) {
                    emitter.emit(Pair.of(id, Pair.of(e.getKey(), e.getValue())));
                }
            }
        }
    }

    static class SampleFn<S>
    extends FilterFn<S> {
        private final Long seed;
        private final double acceptanceProbability;
        private transient Random r;

        SampleFn(double acceptanceProbability, Long seed) {
            Preconditions.checkArgument((0.0 < acceptanceProbability && acceptanceProbability < 1.0 ? 1 : 0) != 0);
            this.seed = seed == null ? Long.valueOf(System.currentTimeMillis()) : seed;
            this.acceptanceProbability = acceptanceProbability;
        }

        @Override
        public void initialize() {
            if (this.r == null) {
                this.r = new Random(this.seed);
            }
        }

        @Override
        public boolean accept(S input) {
            return this.r.nextDouble() < this.acceptanceProbability;
        }
    }
}

