/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.lib;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.apache.crunch.DoFn;
import org.apache.crunch.Emitter;
import org.apache.crunch.MapFn;
import org.apache.crunch.PCollection;
import org.apache.crunch.PGroupedTable;
import org.apache.crunch.PTable;
import org.apache.crunch.Pair;
import org.apache.crunch.fn.IdentityFn;
import org.apache.crunch.fn.PairMapFn;
import org.apache.crunch.types.PGroupedTableType;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;

public class PTables {
    public static <K, V> PTable<K, V> asPTable(PCollection<Pair<K, V>> pcollect) {
        PType<Pair<K, V>> pt = pcollect.getPType();
        PTypeFamily ptf = pt.getFamily();
        PTableType ptt = ptf.tableOf(pt.getSubTypes().get(0), pt.getSubTypes().get(1));
        IdentityFn id = IdentityFn.getInstance();
        return pcollect.parallelDo("asPTable", id, ptt);
    }

    public static <K1, K2, V> PTable<K2, V> mapKeys(PTable<K1, V> ptable, MapFn<K1, K2> mapFn, PType<K2> ptype) {
        return PTables.mapKeys("PTables.mapKeys", ptable, mapFn, ptype);
    }

    public static <K1, K2, V> PTable<K2, V> mapKeys(String name, PTable<K1, V> ptable, MapFn<K1, K2> mapFn, PType<K2> ptype) {
        PTypeFamily ptf = ptable.getTypeFamily();
        return ptable.parallelDo(name, new PairMapFn(mapFn, IdentityFn.getInstance()), (PTableType<K1, V>)ptf.tableOf(ptype, ptable.getValueType()));
    }

    public static <K, U, V> PTable<K, V> mapValues(PTable<K, U> ptable, MapFn<U, V> mapFn, PType<V> ptype) {
        return PTables.mapValues("PTables.mapValues", ptable, mapFn, ptype);
    }

    public static <K, U, V> PTable<K, V> mapValues(String name, PTable<K, U> ptable, MapFn<U, V> mapFn, PType<V> ptype) {
        PTypeFamily ptf = ptable.getTypeFamily();
        return ptable.parallelDo(name, new PairMapFn(IdentityFn.getInstance(), mapFn), (PTableType<K, U>)ptf.tableOf(ptable.getKeyType(), ptype));
    }

    public static <K, U, V> PTable<K, V> mapValues(PGroupedTable<K, U> ptable, MapFn<Iterable<U>, V> mapFn, PType<V> ptype) {
        return PTables.mapValues("PTables.mapValues", ptable, mapFn, ptype);
    }

    public static <K, U, V> PTable<K, V> mapValues(String name, PGroupedTable<K, U> ptable, MapFn<Iterable<U>, V> mapFn, PType<V> ptype) {
        PTypeFamily ptf = ptable.getTypeFamily();
        return ptable.parallelDo(name, new PairMapFn(IdentityFn.getInstance(), mapFn), ptf.tableOf(ptable.getPType().getSubTypes().get(0), ptype));
    }

    public static <K, V> PCollection<K> keys(PTable<K, V> ptable) {
        return ptable.parallelDo("PTables.keys", new DoFn<Pair<K, V>, K>(){

            @Override
            public void process(Pair<K, V> input, Emitter<K> emitter) {
                emitter.emit(input.first());
            }
        }, ptable.getKeyType());
    }

    public static <K, V> PCollection<V> values(PTable<K, V> ptable) {
        return ptable.parallelDo("PTables.values", new DoFn<Pair<K, V>, V>(){

            @Override
            public void process(Pair<K, V> input, Emitter<V> emitter) {
                emitter.emit(input.second());
            }
        }, ptable.getValueType());
    }

    public static <K, V> Pair<K, V> getDetachedValue(PTableType<K, V> tableType, Pair<K, V> value) {
        return Pair.of(tableType.getKeyType().getDetachedValue(value.first()), tableType.getValueType().getDetachedValue(value.second()));
    }

    public static <K, V> Pair<K, Iterable<V>> getGroupedDetachedValue(PGroupedTableType<K, V> groupedTableType, Pair<K, Iterable<V>> value) {
        PTableType<K, V> tableType = groupedTableType.getTableType();
        ArrayList detachedIterable = Lists.newArrayList();
        PType<V> valueType = tableType.getValueType();
        for (V v : value.second()) {
            detachedIterable.add(valueType.getDetachedValue(v));
        }
        return Pair.of(tableType.getKeyType().getDetachedValue(value.first()), detachedIterable);
    }
}

