/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.lib;

import org.apache.crunch.DoFn;
import org.apache.crunch.Emitter;
import org.apache.crunch.PCollection;
import org.apache.crunch.Pair;
import org.apache.crunch.types.PType;

public class Channels {
    public static <T, U> Pair<PCollection<T>, PCollection<U>> split(PCollection<Pair<T, U>> pCollection) {
        PType<Pair<T, U>> pt = pCollection.getPType();
        return Channels.split(pCollection, pt.getSubTypes().get(0), pt.getSubTypes().get(1));
    }

    public static <T, U> Pair<PCollection<T>, PCollection<U>> split(PCollection<Pair<T, U>> pCollection, PType<T> firstPType, PType<U> secondPType) {
        PCollection first = pCollection.parallelDo("Extract first value", new FirstEmittingDoFn(), firstPType);
        PCollection second = pCollection.parallelDo("Extract second value", new FirstEmittingDoFn.SecondEmittingDoFn(), secondPType);
        return Pair.of(first, second);
    }

    static class FirstEmittingDoFn<T, U>
    extends DoFn<Pair<T, U>, T> {
        FirstEmittingDoFn() {
        }

        @Override
        public void process(Pair<T, U> input, Emitter<T> emitter) {
            T first = input.first();
            if (first != null) {
                emitter.emit(first);
            }
        }

        static class SecondEmittingDoFn<T, U>
        extends DoFn<Pair<T, U>, U> {
            SecondEmittingDoFn() {
            }

            @Override
            public void process(Pair<T, U> input, Emitter<U> emitter) {
                U second = input.second();
                if (second != null) {
                    emitter.emit(second);
                }
            }
        }
    }
}

