/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.text.csv;

import java.util.List;
import org.apache.crunch.io.FileReaderFactory;
import org.apache.crunch.io.impl.ReadableDataImpl;
import org.apache.crunch.io.text.csv.CSVFileReaderFactory;
import org.apache.hadoop.fs.Path;

public class CSVReadableData
extends ReadableDataImpl<String> {
    private final int bufferSize;
    private final String inputFileEncoding;
    private final char openQuoteChar;
    private final char closeQuoteChar;
    private final char escapeChar;
    private final int maximumRecordSize;

    protected CSVReadableData(List<Path> paths) {
        this(paths, 65536, "UTF-8", '\"', '\"', '\\', 0x4000000);
    }

    protected CSVReadableData(List<Path> paths, int bufferSize, String inputFileEncoding, char openQuoteChar, char closeQuoteChar, char escapeChar, int maximumRecordSize) {
        super(paths);
        this.bufferSize = bufferSize;
        this.inputFileEncoding = inputFileEncoding;
        this.openQuoteChar = openQuoteChar;
        this.closeQuoteChar = closeQuoteChar;
        this.escapeChar = escapeChar;
        this.maximumRecordSize = maximumRecordSize;
    }

    @Override
    protected FileReaderFactory<String> getFileReaderFactory() {
        return new CSVFileReaderFactory(this.bufferSize, this.inputFileEncoding, this.openQuoteChar, this.closeQuoteChar, this.escapeChar, this.maximumRecordSize);
    }
}

