/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.text.csv;

import java.io.IOException;
import java.util.List;
import org.apache.crunch.ReadableData;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.io.impl.FileSourceImpl;
import org.apache.crunch.io.text.csv.CSVFileReaderFactory;
import org.apache.crunch.io.text.csv.CSVInputFormat;
import org.apache.crunch.io.text.csv.CSVReadableData;
import org.apache.crunch.types.writable.Writables;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;

public class CSVFileSource
extends FileSourceImpl<String>
implements ReadableSource<String> {
    public static final String CSV_BUFFER_SIZE = "csv.buffersize";
    public static final String CSV_INPUT_FILE_ENCODING = "csv.inputfileencoding";
    public static final String CSV_OPEN_QUOTE_CHAR = "csv.openquotechar";
    public static final String CSV_CLOSE_QUOTE_CHAR = "csv.closequotechar";
    public static final String CSV_ESCAPE_CHAR = "csv.escapechar";
    public static final String MAXIMUM_RECORD_SIZE = "csv.maximumrecordsize";
    public static final String INPUT_SPLIT_SIZE = "csv.inputsplitsize";
    private int bufferSize;
    private String inputFileEncoding;
    private char openQuoteChar;
    private char closeQuoteChar;
    private char escapeChar;
    private int maximumRecordSize;

    public CSVFileSource(List<Path> paths) {
        this(paths, 65536, "UTF-8", '\"', '\"', '\\', 0x4000000);
    }

    public CSVFileSource(Path path) {
        this(path, 65536, "UTF-8", '\"', '\"', '\\', 0x4000000);
    }

    public CSVFileSource(List<Path> paths, int bufferSize, String inputFileEncoding, char openQuoteChar, char closeQuoteChar, char escapeChar, int maximumRecordSize) {
        super(paths, Writables.strings(), CSVFileSource.getCSVBundle(bufferSize, inputFileEncoding, openQuoteChar, closeQuoteChar, escapeChar, maximumRecordSize));
        this.setPrivateVariables(bufferSize, inputFileEncoding, openQuoteChar, closeQuoteChar, escapeChar, maximumRecordSize);
    }

    public CSVFileSource(Path path, int bufferSize, String inputFileEncoding, char openQuoteChar, char closeQuoteChar, char escapeChar, int maximumRecordSize) {
        super(path, Writables.strings(), CSVFileSource.getCSVBundle(bufferSize, inputFileEncoding, openQuoteChar, closeQuoteChar, escapeChar, maximumRecordSize));
        this.setPrivateVariables(bufferSize, inputFileEncoding, openQuoteChar, closeQuoteChar, escapeChar, maximumRecordSize);
    }

    @Override
    public Iterable<String> read(Configuration conf) throws IOException {
        return this.read(conf, new CSVFileReaderFactory(this.bufferSize, this.inputFileEncoding, this.openQuoteChar, this.closeQuoteChar, this.escapeChar, this.maximumRecordSize));
    }

    @Override
    public ReadableData<String> asReadable() {
        return new CSVReadableData(this.paths, this.bufferSize, this.inputFileEncoding, this.openQuoteChar, this.closeQuoteChar, this.escapeChar, this.maximumRecordSize);
    }

    @Override
    public String toString() {
        return "CSV(" + this.pathsAsString() + ")";
    }

    private static FormatBundle<CSVInputFormat> getCSVBundle(int bufferSize, String inputFileEncoding, char openQuoteChar, char closeQuoteChar, char escapeChar, int maximumRecordSize) {
        FormatBundle<CSVInputFormat> bundle = FormatBundle.forInput(CSVInputFormat.class);
        bundle.set("crunch.disable.combine.file", "true");
        bundle.set(CSV_BUFFER_SIZE, String.valueOf(bufferSize));
        bundle.set(CSV_INPUT_FILE_ENCODING, String.valueOf(inputFileEncoding));
        bundle.set(CSV_OPEN_QUOTE_CHAR, String.valueOf(openQuoteChar));
        bundle.set(CSV_CLOSE_QUOTE_CHAR, String.valueOf(closeQuoteChar));
        bundle.set(CSV_ESCAPE_CHAR, String.valueOf(escapeChar));
        bundle.set(MAXIMUM_RECORD_SIZE, String.valueOf(maximumRecordSize));
        return bundle;
    }

    private void setPrivateVariables(int bufferSize, String inputFileEncoding, char openQuoteChar, char closeQuoteChar, char escapeChar, int maximumRecordSize) {
        if (this.isSameCharacter(openQuoteChar, escapeChar)) {
            throw new IllegalArgumentException("The open quote (" + openQuoteChar + ") and escape (" + escapeChar + ") characters must be different!");
        }
        if (this.isSameCharacter(closeQuoteChar, escapeChar)) {
            throw new IllegalArgumentException("The close quote (" + closeQuoteChar + ") and escape (" + escapeChar + ") characters must be different!");
        }
        this.bufferSize = bufferSize;
        this.inputFileEncoding = inputFileEncoding;
        this.openQuoteChar = openQuoteChar;
        this.closeQuoteChar = closeQuoteChar;
        this.escapeChar = escapeChar;
        this.maximumRecordSize = maximumRecordSize;
    }

    private boolean isSameCharacter(char c1, char c2) {
        return c2 == c1;
    }
}

