/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.text.csv;

import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.io.FileReaderFactory;
import org.apache.crunch.io.text.csv.CSVRecordIterator;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class CSVFileReaderFactory
implements FileReaderFactory<String> {
    private static final Log LOG = LogFactory.getLog(CSVFileReaderFactory.class);
    private final int bufferSize;
    private final String inputFileEncoding;
    private final char openQuoteChar;
    private final char closeQuoteChar;
    private final char escapeChar;
    private final int maximumRecordSize;

    CSVFileReaderFactory() {
        this(65536, "UTF-8", '\"', '\"', '\\', 0x4000000);
    }

    CSVFileReaderFactory(int bufferSize, String inputFileEncoding, char openQuoteChar, char closeQuoteChar, char escapeChar, int maximumRecordSize) {
        this.bufferSize = bufferSize;
        this.inputFileEncoding = inputFileEncoding;
        this.openQuoteChar = openQuoteChar;
        this.closeQuoteChar = closeQuoteChar;
        this.escapeChar = escapeChar;
        this.maximumRecordSize = maximumRecordSize;
    }

    @Override
    public Iterator<String> read(FileSystem fs, Path path) {
        try {
            FSDataInputStream is = fs.open(path);
            return new CSVRecordIterator((InputStream)is, this.bufferSize, this.inputFileEncoding, this.openQuoteChar, this.closeQuoteChar, this.escapeChar, this.maximumRecordSize);
        }
        catch (IOException e) {
            LOG.info((Object)("Could not read path: " + path), (Throwable)e);
            return Iterators.emptyIterator();
        }
    }
}

