/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.text;

import java.util.List;
import org.apache.crunch.io.FileReaderFactory;
import org.apache.crunch.io.impl.ReadableDataImpl;
import org.apache.crunch.io.text.LineParser;
import org.apache.crunch.io.text.TextFileReaderFactory;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.hadoop.fs.Path;

public class TextReadableData<T>
extends ReadableDataImpl<T> {
    private final PType<T> ptype;
    private final String sep;

    public TextReadableData(List<Path> paths, PType<T> ptype) {
        this(paths, ptype, null);
    }

    public TextReadableData(List<Path> paths, PType<T> ptype, String sep) {
        super(paths);
        this.ptype = ptype;
        this.sep = sep;
    }

    @Override
    protected FileReaderFactory<T> getFileReaderFactory() {
        if (this.sep == null) {
            return new TextFileReaderFactory<T>(this.ptype);
        }
        return new TextFileReaderFactory(LineParser.forTableType((PTableType)this.ptype, this.sep));
    }
}

