/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.text;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.Target;
import org.apache.crunch.io.FileNamingScheme;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.SequentialFileNamingScheme;
import org.apache.crunch.io.impl.FileTargetImpl;
import org.apache.crunch.io.text.TextFileSourceTarget;
import org.apache.crunch.io.text.TextFileTableSourceTarget;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.avro.AvroTextOutputFormat;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.AvroTypeFamily;
import org.apache.crunch.types.writable.WritableType;
import org.apache.crunch.types.writable.WritableTypeFamily;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;

public class TextFileTarget
extends FileTargetImpl {
    private final Map<String, String> extraConf = Maps.newHashMap();

    private static Class<? extends FileOutputFormat> getOutputFormat(PType<?> ptype) {
        if (ptype.getFamily().equals(AvroTypeFamily.getInstance())) {
            return AvroTextOutputFormat.class;
        }
        return TextOutputFormat.class;
    }

    public <T> TextFileTarget(String path) {
        this(new Path(path));
    }

    public <T> TextFileTarget(Path path) {
        this(path, SequentialFileNamingScheme.getInstance());
    }

    public <T> TextFileTarget(Path path, FileNamingScheme fileNamingScheme) {
        super(path, null, fileNamingScheme);
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public String toString() {
        return "Text(" + this.path + ")";
    }

    @Override
    public Target outputConf(String key, String value) {
        this.extraConf.put(key, value);
        return this;
    }

    @Override
    public void configureForMapReduce(Job job, PType<?> ptype, Path outputPath, String name) {
        Converter converter = ptype.getConverter();
        Class keyClass = converter.getKeyClass();
        Class valueClass = converter.getValueClass();
        FormatBundle<? extends FileOutputFormat> fb = FormatBundle.forOutput(TextFileTarget.getOutputFormat(ptype));
        for (Map.Entry<String, String> e : this.extraConf.entrySet()) {
            fb.set(e.getKey(), e.getValue());
        }
        this.configureForMapReduce(job, keyClass, valueClass, fb, outputPath, name);
    }

    @Override
    public <T> SourceTarget<T> asSourceTarget(PType<T> ptype) {
        if (!this.isTextCompatible(ptype)) {
            return null;
        }
        if (ptype instanceof PTableType) {
            return new TextFileTableSourceTarget(this.path, (PTableType)ptype);
        }
        return new TextFileSourceTarget<T>(this.path, ptype);
    }

    private <T> boolean isTextCompatible(PType<T> ptype) {
        if (AvroTypeFamily.getInstance().equals(ptype.getFamily())) {
            AvroType at = (AvroType)ptype;
            if (at.getSchema().equals((Object)Schema.create((Schema.Type)Schema.Type.STRING))) {
                return true;
            }
        } else if (WritableTypeFamily.getInstance().equals(ptype.getFamily())) {
            if (ptype instanceof PTableType) {
                PTableType ptt = (PTableType)ptype;
                return this.isText(ptt.getKeyType()) && this.isText(ptt.getValueType());
            }
            return this.isText(ptype);
        }
        return false;
    }

    private <T> boolean isText(PType<T> wtype) {
        return Text.class.equals(((WritableType)wtype).getSerializationClass());
    }
}

