/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.text;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.crunch.ReadableData;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.io.impl.FileSourceImpl;
import org.apache.crunch.io.text.LineParser;
import org.apache.crunch.io.text.TextFileReaderFactory;
import org.apache.crunch.io.text.TextReadableData;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.avro.AvroTypeFamily;
import org.apache.crunch.types.avro.AvroUtf8InputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;

public class TextFileSource<T>
extends FileSourceImpl<T>
implements ReadableSource<T> {
    private static <S> Class<? extends FileInputFormat<?, ?>> getInputFormat(PType<S> ptype) {
        if (ptype.getFamily().equals(AvroTypeFamily.getInstance())) {
            return AvroUtf8InputFormat.class;
        }
        return TextInputFormat.class;
    }

    public TextFileSource(Path path, PType<T> ptype) {
        this(Collections.singletonList(path), ptype);
    }

    public TextFileSource(List<Path> paths, PType<T> ptype) {
        super(paths, ptype, TextFileSource.getInputFormat(ptype));
        this.inputBundle.set("crunch.disable.combine.file", Boolean.FALSE.toString());
    }

    @Override
    public String toString() {
        return "Text(" + this.pathsAsString() + ")";
    }

    @Override
    public Iterable<T> read(Configuration conf) throws IOException {
        return this.read(conf, new TextFileReaderFactory(LineParser.forType(this.ptype)));
    }

    @Override
    public ReadableData<T> asReadable() {
        return new TextReadableData(this.paths, this.ptype);
    }
}

