/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.text;

import java.io.IOException;
import java.util.List;
import org.apache.crunch.ReadableData;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.io.impl.FileSourceImpl;
import org.apache.crunch.io.text.LineParser;
import org.apache.crunch.io.text.TextFileReaderFactory;
import org.apache.crunch.io.text.TextReadableData;
import org.apache.crunch.types.PType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.lib.input.NLineInputFormat;

public class NLineFileSource<T>
extends FileSourceImpl<T>
implements ReadableSource<T> {
    private static FormatBundle getBundle(int linesPerTask) {
        FormatBundle<NLineInputFormat> bundle = FormatBundle.forInput(NLineInputFormat.class);
        bundle.set("mapreduce.input.lineinputformat.linespermap", String.valueOf(linesPerTask));
        bundle.set("crunch.disable.combine.file", "true");
        return bundle;
    }

    public NLineFileSource(String path, PType<T> ptype, int linesPerTask) {
        this(new Path(path), ptype, linesPerTask);
    }

    public NLineFileSource(Path path, PType<T> ptype, int linesPerTask) {
        super(path, ptype, (FormatBundle<? extends InputFormat>)NLineFileSource.getBundle(linesPerTask));
    }

    public NLineFileSource(List<Path> paths, PType<T> ptype, int linesPerTask) {
        super(paths, ptype, (FormatBundle<? extends InputFormat>)NLineFileSource.getBundle(linesPerTask));
    }

    @Override
    public String toString() {
        return "NLine(" + this.pathsAsString() + ")";
    }

    @Override
    public Iterable<T> read(Configuration conf) throws IOException {
        return this.read(conf, new TextFileReaderFactory(LineParser.forType(this.ptype)));
    }

    @Override
    public ReadableData<T> asReadable() {
        return new TextReadableData(this.paths, this.ptype);
    }
}

