/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.text;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import org.apache.crunch.MapFn;
import org.apache.crunch.Pair;
import org.apache.crunch.fn.CompositeMapFn;
import org.apache.crunch.fn.IdentityFn;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;

abstract class LineParser<T> {
    private MapFn<String, T> mapFn;

    LineParser() {
    }

    public static <S> LineParser<S> forType(PType<S> ptype) {
        return new SimpleLineParser<S>(ptype);
    }

    public static <K, V> LineParser<Pair<K, V>> forTableType(PTableType<K, V> ptt, String sep) {
        return new KeyValueLineParser<K, V>(ptt, sep);
    }

    public void initialize() {
        this.mapFn = this.getMapFn();
        this.mapFn.initialize();
    }

    public T parse(String line) {
        return this.mapFn.map(line);
    }

    protected abstract MapFn<String, T> getMapFn();

    private static <T> MapFn<String, T> getMapFnForPType(PType<T> ptype) {
        MapFn ret = null;
        if (String.class.equals(ptype.getTypeClass())) {
            ret = IdentityFn.getInstance();
        } else {
            ret = ptype.getInputMapFn();
            if (ret instanceof CompositeMapFn) {
                ret = ((CompositeMapFn)ret).getSecond();
            }
        }
        return ret;
    }

    private static class KeyValueLineParser<K, V>
    extends LineParser<Pair<K, V>> {
        private final PTableType<K, V> ptt;
        private final String sep;

        public KeyValueLineParser(PTableType<K, V> ptt, String sep) {
            this.ptt = ptt;
            this.sep = sep;
        }

        @Override
        protected MapFn<String, Pair<K, V>> getMapFn() {
            final MapFn keyMapFn = LineParser.getMapFnForPType(this.ptt.getKeyType());
            final MapFn valueMapFn = LineParser.getMapFnForPType(this.ptt.getValueType());
            return new MapFn<String, Pair<K, V>>(){

                @Override
                public void initialize() {
                    keyMapFn.initialize();
                    valueMapFn.initialize();
                }

                @Override
                public Pair<K, V> map(String input) {
                    ImmutableList kv = ImmutableList.copyOf((Iterable)Splitter.on((String)KeyValueLineParser.this.sep).limit(1).split((CharSequence)input));
                    if (kv.size() != 2) {
                        throw new RuntimeException("Invalid input string: " + input);
                    }
                    return Pair.of(keyMapFn.map(kv.get(0)), valueMapFn.map(kv.get(1)));
                }
            };
        }
    }

    private static class SimpleLineParser<S>
    extends LineParser<S> {
        private final PType<S> ptype;

        public SimpleLineParser(PType<S> ptype) {
            this.ptype = ptype;
        }

        @Override
        protected MapFn<String, S> getMapFn() {
            return LineParser.getMapFnForPType(this.ptype);
        }
    }
}

