/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.seq;

import java.io.IOException;
import java.util.List;
import org.apache.crunch.Pair;
import org.apache.crunch.ReadableData;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.io.impl.FileTableSourceImpl;
import org.apache.crunch.io.seq.SeqFileReadableData;
import org.apache.crunch.io.seq.SeqFileReaderFactory;
import org.apache.crunch.types.PTableType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;

public class SeqFileTableSource<K, V>
extends FileTableSourceImpl<K, V>
implements ReadableSource<Pair<K, V>> {
    public SeqFileTableSource(String path, PTableType<K, V> ptype) {
        this(new Path(path), ptype);
    }

    public SeqFileTableSource(Path path, PTableType<K, V> ptype) {
        super(path, ptype, SequenceFileInputFormat.class);
    }

    public SeqFileTableSource(List<Path> paths, PTableType<K, V> ptype) {
        super(paths, ptype, SequenceFileInputFormat.class);
    }

    @Override
    public Iterable<Pair<K, V>> read(Configuration conf) throws IOException {
        return this.read(conf, new SeqFileReaderFactory(this.getTableType()));
    }

    @Override
    public ReadableData<Pair<K, V>> asReadable() {
        return new SeqFileReadableData<Pair<K, V>>(this.paths, this.getTableType());
    }

    @Override
    public String toString() {
        return "SeqFile(" + this.pathsAsString() + ")";
    }
}

