/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.seq;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.crunch.ReadableData;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.io.impl.FileSourceImpl;
import org.apache.crunch.io.seq.SeqFileReadableData;
import org.apache.crunch.io.seq.SeqFileReaderFactory;
import org.apache.crunch.types.PType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;

public class SeqFileSource<T>
extends FileSourceImpl<T>
implements ReadableSource<T> {
    public SeqFileSource(Path path, PType<T> ptype) {
        this(Collections.singletonList(path), ptype);
    }

    public SeqFileSource(List<Path> paths, PType<T> ptype) {
        super(paths, ptype, SequenceFileInputFormat.class);
        this.inputBundle.set("crunch.disable.combine.file", Boolean.FALSE.toString());
    }

    @Override
    public Iterable<T> read(Configuration conf) throws IOException {
        return this.read(conf, new SeqFileReaderFactory(this.ptype));
    }

    @Override
    public ReadableData<T> asReadable() {
        return new SeqFileReadableData(this.paths, this.ptype);
    }

    @Override
    public String toString() {
        return "SeqFile(" + this.pathsAsString() + ")";
    }
}

