/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.parquet;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.Target;
import org.apache.crunch.io.FileNamingScheme;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.OutputHandler;
import org.apache.crunch.io.SequentialFileNamingScheme;
import org.apache.crunch.io.impl.FileTargetImpl;
import org.apache.crunch.io.parquet.AvroParquetConverter;
import org.apache.crunch.io.parquet.AvroParquetFileSourceTarget;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.avro.AvroType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import parquet.avro.AvroWriteSupport;
import parquet.hadoop.ParquetOutputFormat;
import parquet.hadoop.api.WriteSupport;

public class AvroParquetFileTarget
extends FileTargetImpl {
    private static final String PARQUET_AVRO_SCHEMA_PARAMETER = "parquet.avro.schema";
    private Map<String, String> extraConf = Maps.newHashMap();

    public AvroParquetFileTarget(String path) {
        this(new Path(path));
    }

    public AvroParquetFileTarget(Path path) {
        this(path, SequentialFileNamingScheme.getInstance());
    }

    public AvroParquetFileTarget(Path path, FileNamingScheme fileNamingScheme) {
        super(path, CrunchAvroParquetOutputFormat.class, fileNamingScheme);
    }

    @Override
    public Target outputConf(String key, String value) {
        this.extraConf.put(key, value);
        return this;
    }

    @Override
    public String toString() {
        return "Parquet(" + this.path.toString() + ")";
    }

    @Override
    public boolean accept(OutputHandler handler, PType<?> ptype) {
        if (!(ptype instanceof AvroType)) {
            return false;
        }
        handler.configure(this, ptype);
        return true;
    }

    @Override
    public Converter<?, ?, ?, ?> getConverter(PType<?> ptype) {
        return new AvroParquetConverter((AvroType)ptype);
    }

    @Override
    public void configureForMapReduce(Job job, PType<?> ptype, Path outputPath, String name) {
        AvroType atype = (AvroType)ptype;
        String schemaParam = name == null ? PARQUET_AVRO_SCHEMA_PARAMETER : "parquet.avro.schema." + name;
        FormatBundle<CrunchAvroParquetOutputFormat> fb = FormatBundle.forOutput(CrunchAvroParquetOutputFormat.class);
        for (Map.Entry<String, String> e : this.extraConf.entrySet()) {
            fb.set(e.getKey(), e.getValue());
        }
        fb.set(schemaParam, atype.getSchema().toString());
        this.configureForMapReduce(job, Void.class, atype.getTypeClass(), fb, outputPath, name);
    }

    @Override
    public <T> SourceTarget<T> asSourceTarget(PType<T> ptype) {
        if (ptype instanceof AvroType && IndexedRecord.class.isAssignableFrom(((AvroType)ptype).getTypeClass())) {
            return new AvroParquetFileSourceTarget(this.path, (AvroType)ptype);
        }
        return null;
    }

    static class CrunchAvroParquetOutputFormat
    extends ParquetOutputFormat<IndexedRecord> {
        public CrunchAvroParquetOutputFormat() {
            super((WriteSupport)new CrunchAvroWriteSupport());
        }
    }

    static class CrunchAvroWriteSupport
    extends AvroWriteSupport {
        CrunchAvroWriteSupport() {
        }

        public WriteSupport.WriteContext init(Configuration conf) {
            String outputName = conf.get("crunch.namedoutput");
            if (outputName != null && !outputName.isEmpty()) {
                String schema = conf.get("parquet.avro.schema." + outputName);
                CrunchAvroWriteSupport.setSchema((Configuration)conf, (Schema)new Schema.Parser().parse(schema));
            }
            return super.init(conf);
        }
    }
}

