/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.impl;

import java.io.IOException;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.crunch.Source;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.Target;
import org.apache.crunch.io.OutputHandler;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.PType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;

class SourceTargetImpl<T>
implements SourceTarget<T> {
    protected final Source<T> source;
    protected final Target target;

    public SourceTargetImpl(Source<T> source, Target target) {
        this.source = source;
        this.target = target;
    }

    @Override
    public Source<T> inputConf(String key, String value) {
        this.source.inputConf(key, value);
        return this;
    }

    @Override
    public PType<T> getType() {
        return this.source.getType();
    }

    @Override
    public void configureSource(Job job, int inputId) throws IOException {
        this.source.configureSource(job, inputId);
    }

    @Override
    public long getSize(Configuration configuration) {
        return this.source.getSize(configuration);
    }

    @Override
    public boolean accept(OutputHandler handler, PType<?> ptype) {
        return this.target.accept(handler, ptype);
    }

    public <S> SourceTarget<S> asSourceTarget(PType<S> ptype) {
        if (ptype != null && ptype.equals(this.source.getType())) {
            return this;
        }
        return this.target.asSourceTarget(ptype);
    }

    public boolean equals(Object other) {
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        SourceTargetImpl sti = (SourceTargetImpl)other;
        return this.source.equals(sti.source) && this.target.equals(sti.target);
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.source).append((Object)this.target).toHashCode();
    }

    public String toString() {
        return this.source.toString();
    }

    @Override
    public Target outputConf(String key, String value) {
        this.target.outputConf(key, value);
        return this;
    }

    @Override
    public boolean handleExisting(Target.WriteMode strategy, long lastModifiedAt, Configuration conf) {
        return this.target.handleExisting(strategy, lastModifiedAt, conf);
    }

    @Override
    public long getLastModifiedAt(Configuration configuration) {
        return this.source.getLastModifiedAt(configuration);
    }

    @Override
    public Converter<?, ?, ?, ?> getConverter() {
        return this.source.getConverter();
    }

    @Override
    public Converter<?, ?, ?, ?> getConverter(PType<?> ptype) {
        return this.target.getConverter(ptype);
    }

    @Override
    public SourceTarget<T> conf(String key, String value) {
        this.source.inputConf(key, value);
        this.target.outputConf(key, value);
        return this;
    }
}

