/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.impl;

import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.Target;
import org.apache.crunch.io.CrunchOutputs;
import org.apache.crunch.io.FileNamingScheme;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.OutputHandler;
import org.apache.crunch.io.PathTarget;
import org.apache.crunch.io.SourceTargetHelper;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.PType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;

public class FileTargetImpl
implements PathTarget {
    private static final Log LOG = LogFactory.getLog(FileTargetImpl.class);
    protected final Path path;
    private final FormatBundle<? extends FileOutputFormat> formatBundle;
    private final FileNamingScheme fileNamingScheme;

    public FileTargetImpl(Path path, Class<? extends FileOutputFormat> outputFormatClass, FileNamingScheme fileNamingScheme) {
        this(path, outputFormatClass, fileNamingScheme, (Map<String, String>)ImmutableMap.of());
    }

    public FileTargetImpl(Path path, Class<? extends FileOutputFormat> outputFormatClass, FileNamingScheme fileNamingScheme, Map<String, String> extraConf) {
        this.path = path;
        this.formatBundle = FormatBundle.forOutput(outputFormatClass);
        this.fileNamingScheme = fileNamingScheme;
        if (extraConf != null && !extraConf.isEmpty()) {
            for (Map.Entry<String, String> e : extraConf.entrySet()) {
                this.formatBundle.set(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public Target outputConf(String key, String value) {
        this.formatBundle.set(key, value);
        return this;
    }

    @Override
    public void configureForMapReduce(Job job, PType<?> ptype, Path outputPath, String name) {
        Converter<?, ?, ?, ?> converter = this.getConverter(ptype);
        Class<?> keyClass = converter.getKeyClass();
        Class<?> valueClass = converter.getValueClass();
        this.configureForMapReduce(job, keyClass, valueClass, this.formatBundle, outputPath, name);
    }

    @Deprecated
    protected void configureForMapReduce(Job job, Class keyClass, Class valueClass, Class outputFormatClass, Path outputPath, String name) {
        this.configureForMapReduce(job, keyClass, valueClass, FormatBundle.forOutput(outputFormatClass), outputPath, name);
    }

    protected void configureForMapReduce(Job job, Class keyClass, Class valueClass, FormatBundle formatBundle, Path outputPath, String name) {
        try {
            FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (name == null) {
            job.setOutputFormatClass(formatBundle.getFormatClass());
            formatBundle.configure(job.getConfiguration());
            job.setOutputKeyClass(keyClass);
            job.setOutputValueClass(valueClass);
        } else {
            CrunchOutputs.addNamedOutput(job, name, formatBundle, keyClass, valueClass);
        }
    }

    @Override
    public boolean accept(OutputHandler handler, PType<?> ptype) {
        handler.configure(this, ptype);
        return true;
    }

    @Override
    public Converter<?, ?, ?, ?> getConverter(PType<?> ptype) {
        return ptype.getConverter();
    }

    @Override
    public void handleOutputs(Configuration conf, Path workingPath, int index) throws IOException {
        FileSystem srcFs = workingPath.getFileSystem(conf);
        Path src = this.getSourcePattern(workingPath, index);
        Path[] srcs = FileUtil.stat2Paths((FileStatus[])srcFs.globStatus(src), (Path)src);
        FileSystem dstFs = this.path.getFileSystem(conf);
        if (!dstFs.exists(this.path)) {
            dstFs.mkdirs(this.path);
        }
        boolean sameFs = FileTargetImpl.isCompatible(srcFs, this.path);
        for (Path s : srcs) {
            Path d = this.getDestFile(conf, s, this.path, s.getName().contains("-m-"));
            if (sameFs) {
                srcFs.rename(s, d);
                continue;
            }
            FileUtil.copy((FileSystem)srcFs, (Path)s, (FileSystem)dstFs, (Path)d, (boolean)true, (boolean)true, (Configuration)conf);
        }
        dstFs.create(this.getSuccessIndicator(), true).close();
    }

    protected Path getSuccessIndicator() {
        return new Path(this.path, "_SUCCESS");
    }

    protected Path getSourcePattern(Path workingPath, int index) {
        if (index < 0) {
            return new Path(workingPath, "part-*");
        }
        return new Path(workingPath, "out" + index + "-*");
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    protected static boolean isCompatible(FileSystem fs, Path path) {
        try {
            fs.makeQualified(path);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    protected Path getDestFile(Configuration conf, Path src, Path dir, boolean mapOnlyJob) throws IOException {
        String outputFilename = null;
        String sourceFilename = src.getName();
        outputFilename = mapOnlyJob ? this.getFileNamingScheme().getMapOutputName(conf, dir) : this.getFileNamingScheme().getReduceOutputName(conf, dir, FileTargetImpl.extractPartitionNumber(sourceFilename));
        if (sourceFilename.contains(".")) {
            outputFilename = outputFilename + sourceFilename.substring(sourceFilename.indexOf("."));
        }
        return new Path(dir, outputFilename);
    }

    public static int extractPartitionNumber(String reduceOutputFileName) {
        Matcher matcher = Pattern.compile(".*-r-(\\d{5})").matcher(reduceOutputFileName);
        if (matcher.find()) {
            return Integer.parseInt(matcher.group(1), 10);
        }
        throw new IllegalArgumentException("Reducer output name '" + reduceOutputFileName + "' cannot be parsed");
    }

    @Override
    public FileNamingScheme getFileNamingScheme() {
        return this.fileNamingScheme;
    }

    public boolean equals(Object other) {
        if (other == null || !this.getClass().equals(other.getClass())) {
            return false;
        }
        FileTargetImpl o = (FileTargetImpl)other;
        return this.path.equals((Object)o.path);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.path).toHashCode();
    }

    public String toString() {
        return this.formatBundle.getFormatClass().getSimpleName() + "(" + this.path + ")";
    }

    @Override
    public <T> SourceTarget<T> asSourceTarget(PType<T> ptype) {
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean handleExisting(Target.WriteMode strategy, long lastModForSource, Configuration conf) {
        FileSystem fs = null;
        try {
            fs = this.path.getFileSystem(conf);
        }
        catch (IOException e) {
            LOG.error((Object)"Could not retrieve FileSystem object to check for existing path", (Throwable)e);
            throw new CrunchRuntimeException(e);
        }
        boolean exists = false;
        boolean successful = false;
        long lastModForTarget = -1L;
        try {
            exists = fs.exists(this.path);
            if (exists) {
                successful = fs.exists(this.getSuccessIndicator());
                lastModForTarget = SourceTargetHelper.getLastModifiedAt(fs, this.path);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Exception checking existence of path: " + this.path), (Throwable)e);
            throw new CrunchRuntimeException(e);
        }
        if (exists) {
            switch (strategy) {
                case DEFAULT: {
                    LOG.error((Object)("Path " + this.path + " already exists!"));
                    throw new CrunchRuntimeException("Path already exists: " + this.path);
                }
                case OVERWRITE: {
                    LOG.info((Object)("Removing data at existing path: " + this.path));
                    try {
                        fs.delete(this.path, true);
                        return exists;
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Exception thrown removing data at path: " + this.path), (Throwable)e);
                    }
                    return exists;
                }
                case APPEND: {
                    LOG.info((Object)("Adding output files to existing path: " + this.path));
                    return exists;
                }
                case CHECKPOINT: {
                    if (successful && lastModForTarget > lastModForSource) {
                        LOG.info((Object)("Re-starting pipeline from checkpoint path: " + this.path));
                        return exists;
                    }
                    if (!successful) {
                        LOG.info((Object)("_SUCCESS file not found, Removing data at existing checkpoint path: " + this.path));
                    } else {
                        LOG.info((Object)("Source data has recent updates. Removing data at existing checkpoint path: " + this.path));
                    }
                    try {
                        fs.delete(this.path, true);
                        return false;
                    }
                    catch (IOException e) {
                        LOG.error((Object)("Exception thrown removing data at checkpoint path: " + this.path), (Throwable)e);
                    }
                    return false;
                }
                default: {
                    throw new CrunchRuntimeException("Unknown WriteMode:  " + (Object)((Object)strategy));
                }
            }
        }
        LOG.info((Object)("Will write output files to new path: " + this.path));
        return exists;
    }
}

