/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.impl;

import com.google.common.collect.UnmodifiableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;

public class AutoClosingIterator<T>
extends UnmodifiableIterator<T>
implements Closeable {
    private final Iterator<T> iter;
    private Closeable closeable;

    public AutoClosingIterator(Closeable closeable, Iterator<T> iter) {
        this.closeable = closeable;
        this.iter = iter;
    }

    public boolean hasNext() {
        if (this.iter.hasNext()) {
            return true;
        }
        IOUtils.closeQuietly((Closeable)this);
        return false;
    }

    public T next() {
        return this.iter.next();
    }

    @Override
    public void close() throws IOException {
        if (this.closeable != null) {
            this.closeable.close();
            this.closeable = null;
        }
    }
}

