/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.avro.trevni;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.mapred.AvroKey;
import org.apache.avro.mapreduce.AvroJob;
import org.apache.avro.reflect.ReflectData;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.MetaData;
import org.apache.trevni.avro.AvroColumnWriter;

public class TrevniRecordWriter<T>
extends RecordWriter<AvroKey<T>, NullWritable> {
    public static final String EXT = ".trv";
    public static final String META_PREFIX = "trevni.meta.";
    protected int part = 0;
    protected AvroColumnWriter<T> writer;
    final Path dirPath;
    final FileSystem fs;
    final long blockSize;
    protected Schema schema;
    protected ColumnFileMetaData meta;

    public TrevniRecordWriter(TaskAttemptContext context) throws IOException {
        this.schema = this.initSchema(context);
        this.meta = TrevniRecordWriter.filterMetadata(context.getConfiguration());
        this.writer = new AvroColumnWriter(this.schema, this.meta, (GenericData)ReflectData.get());
        Path outputPath = FileOutputFormat.getOutputPath((JobContext)context);
        String dir = FileOutputFormat.getUniqueFile((TaskAttemptContext)context, (String)"part", (String)"");
        this.dirPath = new Path(outputPath.toString() + "/" + dir);
        this.fs = this.dirPath.getFileSystem(context.getConfiguration());
        this.fs.mkdirs(this.dirPath);
        this.blockSize = this.fs.getDefaultBlockSize();
    }

    public void write(AvroKey<T> key, NullWritable value) throws IOException, InterruptedException {
        this.writer.write(key.datum());
        if (this.writer.sizeEstimate() >= this.blockSize) {
            this.flush();
        }
    }

    protected Schema initSchema(TaskAttemptContext context) {
        boolean isMapOnly = context.getNumReduceTasks() == 0;
        return isMapOnly ? AvroJob.getMapOutputKeySchema((Configuration)context.getConfiguration()) : AvroJob.getOutputKeySchema((Configuration)context.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        FSDataOutputStream out = this.fs.create(new Path(this.dirPath, "part-" + this.part++ + EXT));
        try {
            this.writer.writeTo((OutputStream)out);
        }
        finally {
            out.close();
        }
        this.writer = new AvroColumnWriter(this.schema, this.meta, (GenericData)ReflectData.get());
    }

    public void close(TaskAttemptContext arg0) throws IOException, InterruptedException {
        this.flush();
    }

    static ColumnFileMetaData filterMetadata(Configuration configuration) {
        ColumnFileMetaData meta = new ColumnFileMetaData();
        for (Map.Entry confEntry : configuration) {
            if (!((String)confEntry.getKey()).startsWith(META_PREFIX)) continue;
            meta.put((Object)((String)confEntry.getKey()).substring(META_PREFIX.length()), (Object)((String)confEntry.getValue()).getBytes(MetaData.UTF8));
        }
        return meta;
    }
}

