/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io.avro.trevni;

import java.io.IOException;
import java.util.List;
import org.apache.crunch.ReadableData;
import org.apache.crunch.io.FormatBundle;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.io.avro.trevni.TrevniFileReaderFactory;
import org.apache.crunch.io.avro.trevni.TrevniReadableData;
import org.apache.crunch.io.impl.FileSourceImpl;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.Avros;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.trevni.avro.mapreduce.AvroTrevniKeyInputFormat;

public class TrevniKeySource<T>
extends FileSourceImpl<T>
implements ReadableSource<T> {
    private static <S> FormatBundle getBundle(AvroType<S> ptype) {
        return FormatBundle.forInput(AvroTrevniKeyInputFormat.class).set("avro.input.is.reflect", String.valueOf(ptype.hasReflect())).set("avro.input.schema", ptype.getSchema().toString()).set("crunch.disable.combine.file", Boolean.FALSE.toString()).set("crunch.reflectdatafactory", Avros.REFLECT_DATA_FACTORY.getClass().getName());
    }

    public TrevniKeySource(Path path, AvroType<T> ptype) {
        super(path, ptype, (FormatBundle<? extends InputFormat>)TrevniKeySource.getBundle(ptype));
    }

    public TrevniKeySource(List<Path> paths, AvroType<T> ptype) {
        super(paths, ptype, (FormatBundle<? extends InputFormat>)TrevniKeySource.getBundle(ptype));
    }

    @Override
    public String toString() {
        return "TrevniKey(" + this.pathsAsString() + ")";
    }

    @Override
    public Iterable<T> read(Configuration conf) throws IOException {
        return this.read(conf, new TrevniFileReaderFactory((AvroType)this.ptype));
    }

    @Override
    public ReadableData<T> asReadable() {
        return new TrevniReadableData(this.paths, (AvroType)this.ptype);
    }
}

