/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Map;
import org.apache.crunch.io.FileNamingScheme;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class SequentialFileNamingScheme
implements FileNamingScheme {
    private static final SequentialFileNamingScheme INSTANCE = new SequentialFileNamingScheme();
    private final Map<Path, Integer> cache = Maps.newHashMap();

    public static SequentialFileNamingScheme getInstance() {
        return INSTANCE;
    }

    private SequentialFileNamingScheme() {
    }

    @Override
    public String getMapOutputName(Configuration configuration, Path outputDirectory) throws IOException {
        return this.getSequentialFileName(configuration, outputDirectory, "m");
    }

    @Override
    public String getReduceOutputName(Configuration configuration, Path outputDirectory, int partitionId) throws IOException {
        return this.getSequentialFileName(configuration, outputDirectory, "r");
    }

    private String getSequentialFileName(Configuration configuration, Path outputDirectory, String jobTypeName) throws IOException {
        return String.format("part-%s-%05d", jobTypeName, this.getSequenceNumber(configuration, outputDirectory));
    }

    private synchronized int getSequenceNumber(Configuration conf, Path outputDirectory) throws IOException {
        if (this.cache.containsKey(outputDirectory)) {
            int next = this.cache.get(outputDirectory);
            this.cache.put(outputDirectory, next + 1);
            return next;
        }
        FileSystem fileSystem = outputDirectory.getFileSystem(conf);
        int next = fileSystem.listStatus(outputDirectory).length;
        this.cache.put(outputDirectory, next + 1);
        return next;
    }
}

