/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.crunch.io.FormatBundle;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;

public class CrunchInputs {
    public static final String CRUNCH_INPUTS = "crunch.inputs.dir";
    private static final char RECORD_SEP = ',';
    private static final char FIELD_SEP = ';';
    private static final char PATH_SEP = '|';
    private static final Joiner JOINER = Joiner.on((char)';');
    private static final Splitter SPLITTER = Splitter.on((char)';');

    public static void addInputPath(Job job, Path path, FormatBundle inputBundle, int nodeIndex) {
        CrunchInputs.addInputPaths(job, Collections.singleton(path), inputBundle, nodeIndex);
    }

    public static void addInputPaths(Job job, Collection<Path> paths, FormatBundle inputBundle, int nodeIndex) {
        Configuration conf = job.getConfiguration();
        ArrayList encodedPathStrs = Lists.newArrayListWithExpectedSize((int)paths.size());
        for (Path path : paths) {
            String pathStr = CrunchInputs.encodePath(path);
            Preconditions.checkArgument((pathStr.indexOf(44) == -1 && pathStr.indexOf(59) == -1 && pathStr.indexOf(124) == -1 ? 1 : 0) != 0);
            encodedPathStrs.add(pathStr);
        }
        String inputs = JOINER.join((Object)inputBundle.serialize(), (Object)String.valueOf(nodeIndex), new Object[]{Joiner.on((char)'|').join((Iterable)encodedPathStrs)});
        String existing = conf.get(CRUNCH_INPUTS);
        conf.set(CRUNCH_INPUTS, existing == null ? inputs : existing + ',' + inputs);
    }

    public static Map<FormatBundle, Map<Integer, List<Path>>> getFormatNodeMap(JobContext job) {
        HashMap formatNodeMap = Maps.newHashMap();
        Configuration conf = job.getConfiguration();
        String crunchInputs = conf.get(CRUNCH_INPUTS);
        if (crunchInputs == null || crunchInputs.isEmpty()) {
            return ImmutableMap.of();
        }
        for (String input : Splitter.on((char)',').split((CharSequence)crunchInputs)) {
            ArrayList fields = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)input));
            FormatBundle inputBundle = FormatBundle.fromSerialized((String)fields.get(0), job.getConfiguration());
            if (!formatNodeMap.containsKey(inputBundle)) {
                formatNodeMap.put(inputBundle, Maps.newHashMap());
            }
            Integer nodeIndex = Integer.valueOf((String)fields.get(1));
            if (!((Map)formatNodeMap.get(inputBundle)).containsKey(nodeIndex)) {
                ((Map)formatNodeMap.get(inputBundle)).put(nodeIndex, Lists.newLinkedList());
            }
            List formatNodePaths = (List)((Map)formatNodeMap.get(inputBundle)).get(nodeIndex);
            String encodedPaths = (String)fields.get(2);
            for (String encodedPath : Splitter.on((char)'|').split((CharSequence)encodedPaths)) {
                formatNodePaths.add(CrunchInputs.decodePath(encodedPath));
            }
        }
        return formatNodeMap;
    }

    private static String encodePath(Path path) {
        try {
            return URLEncoder.encode(path.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static Path decodePath(String encodedPath) {
        try {
            return new Path(URLDecoder.decode(encodedPath, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

