/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io;

import org.apache.crunch.Target;
import org.apache.crunch.io.parquet.AvroParquetFileSourceTarget;
import org.apache.crunch.io.parquet.AvroParquetFileTarget;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import parquet.hadoop.codec.SnappyCodec;

public class Compress {
    public static <T extends Target> T compress(T target, Class<? extends CompressionCodec> codecClass) {
        return (T)target.outputConf("mapred.output.compress", "true").outputConf("mapred.output.compression.codec", codecClass.getCanonicalName());
    }

    public static <T extends Target> T gzip(T target) {
        return (T)Compress.compress(target, GzipCodec.class).outputConf("avro.output.codec", "deflate");
    }

    public static <T extends Target> T snappy(T target) {
        Class<org.apache.hadoop.io.compress.SnappyCodec> snappyCodec = org.apache.hadoop.io.compress.SnappyCodec.class;
        if (target instanceof AvroParquetFileTarget || target instanceof AvroParquetFileSourceTarget) {
            snappyCodec = SnappyCodec.class;
        }
        return (T)Compress.compress(target, snappyCodec).outputConf("avro.output.codec", "snappy");
    }
}

