/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io;

import com.google.common.collect.UnmodifiableIterator;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.apache.crunch.io.FileReaderFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;

public class CompositePathIterable<T>
implements Iterable<T> {
    private final FileStatus[] stati;
    private final FileSystem fs;
    private final FileReaderFactory<T> readerFactory;
    private static final PathFilter FILTER = new PathFilter(){

        public boolean accept(Path path) {
            String name = path.getName();
            return !name.startsWith("_") && !name.startsWith(".");
        }
    };

    public static <S> Iterable<S> create(FileSystem fs, Path path, FileReaderFactory<S> readerFactory) throws IOException {
        if (!fs.exists(path)) {
            throw new IOException("No files found to materialize at: " + path);
        }
        FileStatus[] stati = null;
        try {
            stati = fs.listStatus(path, FILTER);
        }
        catch (FileNotFoundException e) {
            stati = null;
        }
        if (stati == null) {
            throw new IOException("No files found to materialize at: " + path);
        }
        if (stati.length == 0) {
            return Collections.emptyList();
        }
        return new CompositePathIterable<S>(stati, fs, readerFactory);
    }

    private CompositePathIterable(FileStatus[] stati, FileSystem fs, FileReaderFactory<T> readerFactory) {
        this.stati = stati;
        this.fs = fs;
        this.readerFactory = readerFactory;
    }

    @Override
    public Iterator<T> iterator() {
        return new UnmodifiableIterator<T>(){
            private int index = 0;
            private Iterator<T> iter = CompositePathIterable.access$200(CompositePathIterable.this).read(CompositePathIterable.access$000(CompositePathIterable.this), CompositePathIterable.access$100(CompositePathIterable.this)[this.index++].getPath());

            public boolean hasNext() {
                if (!this.iter.hasNext()) {
                    while (this.index < CompositePathIterable.this.stati.length) {
                        this.iter = CompositePathIterable.this.readerFactory.read(CompositePathIterable.this.fs, CompositePathIterable.this.stati[this.index++].getPath());
                        if (!this.iter.hasNext()) continue;
                        return true;
                    }
                    return false;
                }
                return true;
            }

            public T next() {
                return this.iter.next();
            }
        };
    }
}

