/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.io;

import org.apache.avro.generic.GenericData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.TableSourceTarget;
import org.apache.crunch.io.From;
import org.apache.crunch.io.avro.AvroFileSourceTarget;
import org.apache.crunch.io.seq.SeqFileSourceTarget;
import org.apache.crunch.io.seq.SeqFileTableSourceTarget;
import org.apache.crunch.io.text.TextFileSourceTarget;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;
import org.apache.crunch.types.avro.AvroType;
import org.apache.crunch.types.avro.Avros;
import org.apache.crunch.types.writable.Writables;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.Writable;

public class At {
    public static <T extends SpecificRecord> SourceTarget<T> avroFile(String pathName, Class<T> avroClass) {
        return At.avroFile(new Path(pathName), avroClass);
    }

    public static <T extends SpecificRecord> SourceTarget<T> avroFile(Path path, Class<T> avroClass) {
        return At.avroFile(path, Avros.specifics(avroClass));
    }

    public static SourceTarget<GenericData.Record> avroFile(String pathName) {
        return At.avroFile(new Path(pathName));
    }

    public static SourceTarget<GenericData.Record> avroFile(Path path) {
        return At.avroFile(path, new Configuration());
    }

    public static SourceTarget<GenericData.Record> avroFile(Path path, Configuration conf) {
        return At.avroFile(path, Avros.generics(From.getSchemaFromPath(path, conf)));
    }

    public static <T> SourceTarget<T> avroFile(String pathName, PType<T> ptype) {
        return At.avroFile(new Path(pathName), ptype);
    }

    public static <T> SourceTarget<T> avroFile(Path path, PType<T> ptype) {
        return new AvroFileSourceTarget(path, (AvroType)ptype);
    }

    public static <T extends Writable> SourceTarget<T> sequenceFile(String pathName, Class<T> valueClass) {
        return At.sequenceFile(new Path(pathName), valueClass);
    }

    public static <T extends Writable> SourceTarget<T> sequenceFile(Path path, Class<T> valueClass) {
        return At.sequenceFile(path, Writables.writables(valueClass));
    }

    public static <T> SourceTarget<T> sequenceFile(String pathName, PType<T> ptype) {
        return At.sequenceFile(new Path(pathName), ptype);
    }

    public static <T> SourceTarget<T> sequenceFile(Path path, PType<T> ptype) {
        return new SeqFileSourceTarget<T>(path, ptype);
    }

    public static <K extends Writable, V extends Writable> TableSourceTarget<K, V> sequenceFile(String pathName, Class<K> keyClass, Class<V> valueClass) {
        return At.sequenceFile(new Path(pathName), keyClass, valueClass);
    }

    public static <K extends Writable, V extends Writable> TableSourceTarget<K, V> sequenceFile(Path path, Class<K> keyClass, Class<V> valueClass) {
        return At.sequenceFile(path, Writables.writables(keyClass), Writables.writables(valueClass));
    }

    public static <K, V> TableSourceTarget<K, V> sequenceFile(String pathName, PType<K> keyType, PType<V> valueType) {
        return At.sequenceFile(new Path(pathName), keyType, valueType);
    }

    public static <K, V> TableSourceTarget<K, V> sequenceFile(Path path, PType<K> keyType, PType<V> valueType) {
        PTypeFamily ptf = keyType.getFamily();
        return new SeqFileTableSourceTarget<K, V>(path, ptf.tableOf(keyType, valueType));
    }

    public static SourceTarget<String> textFile(String pathName) {
        return At.textFile(new Path(pathName));
    }

    public static SourceTarget<String> textFile(Path path) {
        return At.textFile(path, Writables.strings());
    }

    public static <T> SourceTarget<T> textFile(String pathName, PType<T> ptype) {
        return At.textFile(new Path(pathName), ptype);
    }

    public static <T> SourceTarget<T> textFile(Path path, PType<T> ptype) {
        return new TextFileSourceTarget<T>(path, ptype);
    }
}

