/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.run;

import java.io.IOException;
import java.util.List;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.impl.mr.run.NodeContext;
import org.apache.crunch.impl.mr.run.RTNode;
import org.apache.crunch.io.CrunchOutputs;
import org.apache.crunch.util.DistCache;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

class CrunchTaskContext {
    private final TaskInputOutputContext<Object, Object, Object, Object> taskContext;
    private final NodeContext nodeContext;
    private final List<RTNode> nodes;
    private CrunchOutputs<Object, Object> multipleOutputs;

    public CrunchTaskContext(TaskInputOutputContext<Object, Object, Object, Object> taskContext, NodeContext nodeContext) {
        this.taskContext = taskContext;
        this.nodeContext = nodeContext;
        Configuration conf = taskContext.getConfiguration();
        Path path = new Path(new Path(conf.get("crunch.work.dir")), nodeContext.toString());
        try {
            this.nodes = (List)DistCache.read(conf, path);
        }
        catch (IOException e) {
            throw new CrunchRuntimeException("Could not read runtime node information", e);
        }
    }

    public TaskInputOutputContext<Object, Object, Object, Object> getContext() {
        return this.taskContext;
    }

    public NodeContext getNodeContext() {
        return this.nodeContext;
    }

    public List<RTNode> getNodes() {
        return this.nodes;
    }

    public boolean isDebugRun() {
        Configuration conf = this.taskContext.getConfiguration();
        return conf.getBoolean("crunch.debug", false);
    }

    public void cleanup() {
        if (this.multipleOutputs != null) {
            try {
                this.multipleOutputs.close();
            }
            catch (IOException e) {
                throw new CrunchRuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new CrunchRuntimeException(e);
            }
        }
    }

    public CrunchOutputs<Object, Object> getMultipleOutputs() {
        if (this.multipleOutputs == null) {
            this.multipleOutputs = new CrunchOutputs<Object, Object>(this.taskContext);
        }
        return this.multipleOutputs;
    }
}

