/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.run;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.crunch.impl.SingleUseIterable;
import org.apache.crunch.impl.mr.run.CrunchTaskContext;
import org.apache.crunch.impl.mr.run.NodeContext;
import org.apache.crunch.impl.mr.run.RTNode;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class CrunchReducer
extends Reducer<Object, Object, Object, Object> {
    private static final Log LOG = LogFactory.getLog(CrunchReducer.class);
    private RTNode node;
    private CrunchTaskContext ctxt;
    private boolean debug;

    protected NodeContext getNodeContext() {
        return NodeContext.REDUCE;
    }

    protected void setup(Reducer.Context context) {
        if (this.ctxt == null) {
            this.ctxt = new CrunchTaskContext((TaskInputOutputContext<Object, Object, Object, Object>)context, this.getNodeContext());
            this.debug = this.ctxt.isDebugRun();
        }
        this.node = this.ctxt.getNodes().get(0);
        this.node.initialize(this.ctxt);
    }

    protected void reduce(Object key, Iterable<Object> values, Reducer.Context context) {
        values = new SingleUseIterable<Object>(values);
        if (this.debug) {
            try {
                this.node.processIterable(key, values);
            }
            catch (Exception e) {
                LOG.error((Object)"Reducer exception", (Throwable)e);
            }
        } else {
            this.node.processIterable(key, values);
        }
    }

    protected void cleanup(Reducer.Context context) {
        this.node.cleanup();
        this.ctxt.cleanup();
    }
}

