/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.run;

import java.io.IOException;
import org.apache.crunch.hadoop.mapreduce.TaskAttemptContextFactory;
import org.apache.crunch.impl.mr.run.CrunchInputSplit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.CombineFileSplit;
import org.apache.hadoop.mapreduce.lib.input.FileSplit;
import org.apache.hadoop.util.ReflectionUtils;

class CrunchRecordReader<K, V>
extends RecordReader<K, V> {
    private RecordReader<K, V> curReader;
    private CrunchInputSplit crunchSplit;
    private CombineFileSplit combineFileSplit;
    private TaskAttemptContext context;
    private int idx;
    private long progress;

    public CrunchRecordReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.crunchSplit = (CrunchInputSplit)inputSplit;
        if (this.crunchSplit.get() instanceof CombineFileSplit) {
            this.combineFileSplit = (CombineFileSplit)this.crunchSplit.get();
        }
        this.context = context;
        Configuration conf = this.crunchSplit.getConf();
        if (conf == null) {
            conf = context.getConfiguration();
            this.crunchSplit.setConf(conf);
        }
        this.initNextRecordReader();
    }

    private boolean initNextRecordReader() throws IOException, InterruptedException {
        if (this.combineFileSplit != null) {
            if (this.curReader != null) {
                this.curReader.close();
                this.curReader = null;
                if (this.idx > 0) {
                    this.progress += this.combineFileSplit.getLength(this.idx - 1);
                }
            }
            if (this.idx == this.combineFileSplit.getNumPaths()) {
                return false;
            }
        } else if (this.idx > 0) {
            return false;
        }
        ++this.idx;
        Configuration conf = this.crunchSplit.getConf();
        InputFormat inputFormat = (InputFormat)ReflectionUtils.newInstance(this.crunchSplit.getInputFormatClass(), (Configuration)conf);
        this.curReader = inputFormat.createRecordReader(this.getDelegateSplit(), TaskAttemptContextFactory.create(conf, this.context.getTaskAttemptID()));
        return true;
    }

    private InputSplit getDelegateSplit() throws IOException {
        if (this.combineFileSplit != null) {
            return new FileSplit(this.combineFileSplit.getPath(this.idx - 1), this.combineFileSplit.getOffset(this.idx - 1), this.combineFileSplit.getLength(this.idx - 1), this.combineFileSplit.getLocations());
        }
        return this.crunchSplit.get();
    }

    public void close() throws IOException {
        if (this.curReader != null) {
            this.curReader.close();
            this.curReader = null;
        }
    }

    public K getCurrentKey() throws IOException, InterruptedException {
        return (K)this.curReader.getCurrentKey();
    }

    public V getCurrentValue() throws IOException, InterruptedException {
        return (V)this.curReader.getCurrentValue();
    }

    public float getProgress() throws IOException, InterruptedException {
        float curProgress = 0.0f;
        if (null != this.curReader) {
            curProgress = this.curReader.getProgress() * (float)this.getCurLength();
        }
        return Math.min(1.0f, ((float)this.progress + curProgress) / this.getOverallLength());
    }

    private long getCurLength() {
        if (this.combineFileSplit == null) {
            return 1L;
        }
        return this.combineFileSplit.getLength(this.idx - 1);
    }

    private float getOverallLength() {
        if (this.combineFileSplit == null) {
            return 1.0f;
        }
        return this.combineFileSplit.getLength();
    }

    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.crunchSplit = (CrunchInputSplit)inputSplit;
        this.context = context;
        Configuration conf = this.crunchSplit.getConf();
        if (conf == null) {
            conf = context.getConfiguration();
            this.crunchSplit.setConf(conf);
        }
        if (this.crunchSplit.get() instanceof CombineFileSplit) {
            this.combineFileSplit = (CombineFileSplit)this.crunchSplit.get();
        }
        if (this.curReader != null) {
            this.curReader.initialize(this.getDelegateSplit(), TaskAttemptContextFactory.create(conf, context.getTaskAttemptID()));
        }
    }

    public boolean nextKeyValue() throws IOException, InterruptedException {
        while (this.curReader == null || !this.curReader.nextKeyValue()) {
            if (!this.initNextRecordReader()) {
                return false;
            }
            if (this.curReader == null) continue;
            this.curReader.initialize(this.getDelegateSplit(), TaskAttemptContextFactory.create(this.crunchSplit.getConf(), this.context.getTaskAttemptID()));
        }
        return true;
    }
}

