/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.run;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.crunch.impl.mr.run.CrunchCombineFileInputFormat;
import org.apache.crunch.impl.mr.run.CrunchInputSplit;
import org.apache.crunch.impl.mr.run.CrunchRecordReader;
import org.apache.crunch.io.CrunchInputs;
import org.apache.crunch.io.FormatBundle;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public class CrunchInputFormat<K, V>
extends InputFormat<K, V> {
    public List<InputSplit> getSplits(JobContext job) throws IOException, InterruptedException {
        ArrayList splits = Lists.newArrayList();
        Configuration base = job.getConfiguration();
        Map<FormatBundle, Map<Integer, List<Path>>> formatNodeMap = CrunchInputs.getFormatNodeMap(job);
        for (Map.Entry<FormatBundle, Map<Integer, List<Path>>> entry : formatNodeMap.entrySet()) {
            FormatBundle inputBundle = entry.getKey();
            Configuration conf = new Configuration(base);
            inputBundle.configure(conf);
            Job jobCopy = new Job(conf);
            Object format = (InputFormat)ReflectionUtils.newInstance(inputBundle.getFormatClass(), (Configuration)jobCopy.getConfiguration());
            if (format instanceof FileInputFormat && !conf.getBoolean("crunch.disable.combine.file", true)) {
                format = new CrunchCombineFileInputFormat((JobContext)jobCopy);
            }
            for (Map.Entry<Integer, List<Path>> nodeEntry : entry.getValue().entrySet()) {
                Integer nodeIndex = nodeEntry.getKey();
                List<Path> paths = nodeEntry.getValue();
                FileInputFormat.setInputPaths((Job)jobCopy, (Path[])paths.toArray(new Path[paths.size()]));
                List pathSplits = format.getSplits((JobContext)jobCopy);
                for (InputSplit pathSplit : pathSplits) {
                    splits.add(new CrunchInputSplit(pathSplit, inputBundle, nodeIndex, jobCopy.getConfiguration()));
                }
            }
        }
        return splits;
    }

    public RecordReader<K, V> createRecordReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        return new CrunchRecordReader(inputSplit, context);
    }
}

