/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.plan;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.crunch.Source;
import org.apache.crunch.impl.dist.collect.BaseGroupedTable;
import org.apache.crunch.impl.dist.collect.BaseInputCollection;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.impl.mr.plan.Edge;

class Vertex {
    private final PCollectionImpl impl;
    private boolean output;
    private Set<Edge> incoming;
    private Set<Edge> outgoing;

    public Vertex(PCollectionImpl impl) {
        this.impl = impl;
        this.incoming = Sets.newHashSet();
        this.outgoing = Sets.newHashSet();
    }

    public PCollectionImpl getPCollection() {
        return this.impl;
    }

    public boolean isInput() {
        return this.impl instanceof BaseInputCollection;
    }

    public boolean isGBK() {
        return this.impl instanceof BaseGroupedTable;
    }

    public void setOutput() {
        this.output = true;
    }

    public boolean isOutput() {
        return this.output;
    }

    public Source getSource() {
        if (this.isInput()) {
            return ((BaseInputCollection)this.impl).getSource();
        }
        return null;
    }

    public void addIncoming(Edge edge) {
        this.incoming.add(edge);
    }

    public void addOutgoing(Edge edge) {
        this.outgoing.add(edge);
    }

    public List<Vertex> getAllNeighbors() {
        ArrayList n = Lists.newArrayList();
        for (Edge e : this.incoming) {
            n.add(e.getHead());
        }
        for (Edge e : this.outgoing) {
            n.add(e.getTail());
        }
        return n;
    }

    public Set<Edge> getIncomingEdges() {
        return this.incoming;
    }

    public Set<Edge> getOutgoingEdges() {
        return this.outgoing;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Vertex)) {
            return false;
        }
        Vertex other = (Vertex)obj;
        return this.impl.equals(other.impl);
    }

    public int hashCode() {
        return 17 + 37 * this.impl.hashCode();
    }

    public String toString() {
        return new ReflectionToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).setExcludeFieldNames(new String[]{"outgoing", "incoming"}).toString();
    }
}

