/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.plan;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.LinkedList;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;

class NodePath
implements Iterable<PCollectionImpl<?>> {
    private LinkedList<PCollectionImpl<?>> path;

    public NodePath() {
        this.path = Lists.newLinkedList();
    }

    public NodePath(PCollectionImpl<?> tail) {
        this.path = Lists.newLinkedList();
        this.path.add(tail);
    }

    public NodePath(NodePath other) {
        this.path = Lists.newLinkedList(other.path);
    }

    public void push(PCollectionImpl<?> stage) {
        this.path.push(stage);
    }

    public NodePath close(PCollectionImpl<?> head) {
        this.path.push(head);
        return this;
    }

    @Override
    public Iterator<PCollectionImpl<?>> iterator() {
        return this.path.iterator();
    }

    public Iterator<PCollectionImpl<?>> descendingIterator() {
        return this.path.descendingIterator();
    }

    public PCollectionImpl<?> get(int index) {
        return this.path.get(index);
    }

    public PCollectionImpl<?> head() {
        return this.path.peekFirst();
    }

    public PCollectionImpl<?> tail() {
        return this.path.peekLast();
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof NodePath)) {
            return false;
        }
        NodePath nodePath = (NodePath)other;
        return this.path.equals(nodePath.path);
    }

    public int hashCode() {
        return 17 + 37 * this.path.hashCode();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (PCollectionImpl pCollectionImpl : this.path) {
            sb.append(pCollectionImpl.getName() + "|");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public NodePath splitAt(int splitIndex, PCollectionImpl<?> newHead) {
        NodePath top = new NodePath();
        for (int i = 0; i <= splitIndex; ++i) {
            top.path.add(this.path.get(i));
        }
        LinkedList nextPath = Lists.newLinkedList();
        nextPath.add(newHead);
        nextPath.addAll(this.path.subList(splitIndex + 1, this.path.size()));
        this.path = nextPath;
        return top;
    }

    public NodePath splitAt(PCollectionImpl split, PCollectionImpl<?> newHead) {
        NodePath top = new NodePath();
        int splitIndex = 0;
        for (PCollectionImpl pCollectionImpl : this.path) {
            top.path.add(pCollectionImpl);
            if (pCollectionImpl == split) break;
            ++splitIndex;
        }
        LinkedList nextPath = Lists.newLinkedList();
        nextPath.add(newHead);
        nextPath.addAll(this.path.subList(splitIndex + 1, this.path.size()));
        this.path = nextPath;
        return top;
    }
}

