/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.plan;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.Target;
import org.apache.crunch.impl.mr.plan.DoNode;
import org.apache.crunch.io.MapReduceTarget;
import org.apache.crunch.io.OutputHandler;
import org.apache.crunch.io.PathTarget;
import org.apache.crunch.types.PType;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;

public class MSCROutputHandler
implements OutputHandler {
    private final Job job;
    private final Path path;
    private final boolean mapOnlyJob;
    private DoNode workingNode;
    private Map<Integer, PathTarget> multiPaths;
    private int jobCount;

    public MSCROutputHandler(Job job, Path outputPath, boolean mapOnlyJob) {
        this.job = job;
        this.path = outputPath;
        this.mapOnlyJob = mapOnlyJob;
        this.multiPaths = Maps.newHashMap();
    }

    public void configureNode(DoNode node, Target target) {
        this.workingNode = node;
        if (!target.accept(this, node.getPType())) {
            throw new CrunchRuntimeException("Target " + target + " cannot serialize PType of class: " + node.getPType().getClass());
        }
    }

    @Override
    public boolean configure(Target target, PType<?> ptype) {
        if (target instanceof MapReduceTarget) {
            if (target instanceof PathTarget) {
                this.multiPaths.put(this.jobCount, (PathTarget)target);
            }
            String name = "out" + this.jobCount;
            ++this.jobCount;
            this.workingNode.setOutputName(name);
            ((MapReduceTarget)target).configureForMapReduce(this.job, ptype, this.path, name);
            return true;
        }
        return false;
    }

    public boolean isMapOnlyJob() {
        return this.mapOnlyJob;
    }

    public Map<Integer, PathTarget> getMultiPaths() {
        return this.multiPaths;
    }
}

