/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.plan;

import org.apache.crunch.impl.dist.collect.BaseDoCollection;
import org.apache.crunch.impl.dist.collect.BaseDoTable;
import org.apache.crunch.impl.dist.collect.BaseGroupedTable;
import org.apache.crunch.impl.dist.collect.BaseInputCollection;
import org.apache.crunch.impl.dist.collect.BaseUnionCollection;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.impl.mr.plan.Graph;
import org.apache.crunch.impl.mr.plan.NodePath;
import org.apache.crunch.impl.mr.plan.Vertex;

class GraphBuilder
implements PCollectionImpl.Visitor {
    private Graph graph = new Graph();
    private Vertex workingVertex;
    private NodePath workingPath;

    GraphBuilder() {
    }

    public Graph getGraph() {
        return this.graph;
    }

    public void visitOutput(PCollectionImpl<?> output) {
        this.workingVertex = this.graph.addVertex(output, true);
        this.workingPath = new NodePath();
        output.accept(this);
    }

    @Override
    public void visitInputCollection(BaseInputCollection<?> collection) {
        Vertex v = this.graph.addVertex(collection, false);
        this.graph.getEdge(v, this.workingVertex).addNodePath(this.workingPath.close(collection));
    }

    @Override
    public void visitUnionCollection(BaseUnionCollection<?> collection) {
        Vertex baseVertex = this.workingVertex;
        NodePath basePath = this.workingPath;
        for (PCollectionImpl<?> parent : collection.getParents()) {
            this.workingPath = new NodePath(basePath);
            this.workingVertex = baseVertex;
            this.processParent(parent);
        }
    }

    @Override
    public void visitDoCollection(BaseDoCollection<?> collection) {
        this.workingPath.push(collection);
        this.processParent(collection.getOnlyParent());
    }

    @Override
    public void visitDoTable(BaseDoTable<?, ?> collection) {
        this.workingPath.push(collection);
        this.processParent(collection.getOnlyParent());
    }

    @Override
    public void visitGroupedTable(BaseGroupedTable<?, ?> collection) {
        Vertex v = this.graph.addVertex(collection, false);
        this.graph.getEdge(v, this.workingVertex).addNodePath(this.workingPath.close(collection));
        this.workingVertex = v;
        this.workingPath = new NodePath(collection);
        this.processParent(collection.getOnlyParent());
    }

    private void processParent(PCollectionImpl<?> parent) {
        Vertex v = this.graph.getVertexAt(parent);
        if (v == null) {
            parent.accept(this);
        } else {
            this.graph.getEdge(v, this.workingVertex).addNodePath(this.workingPath.close(parent));
        }
    }
}

