/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.plan;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.crunch.impl.dist.collect.BaseGroupedTable;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.impl.mr.plan.NodePath;
import org.apache.crunch.impl.mr.plan.Vertex;

class Edge {
    private final Vertex head;
    private final Vertex tail;
    private final Set<NodePath> paths;
    private static Comparator<NodePath> NODE_CMP = new Comparator<NodePath>(){

        @Override
        public int compare(NodePath left, NodePath right) {
            if (left == right || left.equals(right)) {
                return 0;
            }
            return left.toString().compareTo(right.toString());
        }
    };
    private static Comparator<PCollectionImpl<?>> PCOL_CMP = new Comparator<PCollectionImpl<?>>(){

        @Override
        public int compare(PCollectionImpl<?> left, PCollectionImpl<?> right) {
            if (left == right || left.equals(right)) {
                return 0;
            }
            String leftName = left.getName();
            String rightName = right.getName();
            if (leftName == null || rightName == null || leftName.equals(rightName)) {
                return left.hashCode() < right.hashCode() ? -1 : 1;
            }
            return leftName.compareTo(rightName);
        }
    };

    Edge(Vertex head, Vertex tail) {
        this.head = head;
        this.tail = tail;
        this.paths = Sets.newTreeSet(NODE_CMP);
    }

    public Vertex getHead() {
        return this.head;
    }

    public Vertex getTail() {
        return this.tail;
    }

    public void addNodePath(NodePath path) {
        this.paths.add(path);
    }

    public void addAllNodePaths(Collection<NodePath> paths) {
        this.paths.addAll(paths);
    }

    public Set<NodePath> getNodePaths() {
        return this.paths;
    }

    public Map<NodePath, PCollectionImpl> getSplitPoints(boolean breakpointsOnly) {
        ArrayList np = Lists.newArrayList(this.paths);
        ArrayList smallestOverallPerPath = Lists.newArrayListWithExpectedSize((int)np.size());
        TreeMap pathCounts = Maps.newTreeMap(PCOL_CMP);
        HashMap splitPoints = Maps.newHashMap();
        for (int i = 0; i < np.size(); ++i) {
            long bestSize = Long.MAX_VALUE;
            boolean breakpoint = false;
            PCollectionImpl<?> best = null;
            for (PCollectionImpl<?> pc : (NodePath)np.get(i)) {
                Set cnts;
                if (pc instanceof BaseGroupedTable || breakpointsOnly && !pc.isBreakpoint()) continue;
                if (pc.isBreakpoint()) {
                    if (!breakpoint || pc.getSize() < bestSize) {
                        best = pc;
                        bestSize = pc.getSize();
                        breakpoint = true;
                    }
                } else if (!breakpoint && pc.getSize() < bestSize) {
                    best = pc;
                    bestSize = pc.getSize();
                }
                if ((cnts = (Set)pathCounts.get(pc)) == null) {
                    cnts = Sets.newHashSet();
                    pathCounts.put(pc, cnts);
                }
                cnts.add(i);
            }
            smallestOverallPerPath.add(best);
            if (!breakpoint) continue;
            splitPoints.put(np.get(i), best);
        }
        HashSet missing = Sets.newHashSet();
        for (int i = 0; i < np.size(); ++i) {
            if (splitPoints.containsKey(np.get(i))) continue;
            missing.add(i);
        }
        if (breakpointsOnly && missing.size() > 0) {
            return ImmutableMap.of();
        }
        if (missing.isEmpty()) {
            return splitPoints;
        }
        HashSet smallest = Sets.newHashSet();
        long smallestSize = 0L;
        for (Integer id : missing) {
            PCollectionImpl s = (PCollectionImpl)smallestOverallPerPath.get(id);
            if (smallest.contains(s)) continue;
            smallest.add(s);
            smallestSize += s.getSize();
        }
        PCollectionImpl singleBest = null;
        long singleSmallestSize = Long.MAX_VALUE;
        for (Map.Entry e : pathCounts.entrySet()) {
            if (!Sets.difference((Set)missing, (Set)((Set)e.getValue())).isEmpty() || ((PCollectionImpl)e.getKey()).getSize() >= singleSmallestSize) continue;
            singleBest = (PCollectionImpl)e.getKey();
            singleSmallestSize = singleBest.getSize();
        }
        if (smallestSize < singleSmallestSize) {
            for (Integer id : missing) {
                splitPoints.put(np.get(id), smallestOverallPerPath.get(id));
            }
        } else {
            for (Integer id : missing) {
                splitPoints.put(np.get(id), singleBest);
            }
        }
        return splitPoints;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Edge)) {
            return false;
        }
        Edge e = (Edge)other;
        return this.head.equals(e.head) && this.tail.equals(e.tail) && this.paths.equals(e.paths);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.head).append((Object)this.tail).toHashCode();
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

