/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.plan;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.crunch.DoFn;
import org.apache.crunch.MapFn;
import org.apache.crunch.ParallelDoOptions;
import org.apache.crunch.Source;
import org.apache.crunch.fn.IdentityFn;
import org.apache.crunch.impl.mr.run.NodeContext;
import org.apache.crunch.impl.mr.run.RTNode;
import org.apache.crunch.types.Converter;
import org.apache.crunch.types.PGroupedTableType;
import org.apache.crunch.types.PType;
import org.apache.hadoop.conf.Configuration;

public class DoNode {
    private static final List<DoNode> NO_CHILDREN = ImmutableList.of();
    private final DoFn fn;
    private final String name;
    private final PType<?> ptype;
    private final List<DoNode> children;
    private final Converter outputConverter;
    private final Source<?> source;
    private final ParallelDoOptions options;
    private String outputName;

    private DoNode(DoFn fn, String name, PType<?> ptype, List<DoNode> children, Converter outputConverter, Source<?> source, ParallelDoOptions options) {
        this.fn = fn;
        this.name = name;
        this.ptype = ptype;
        this.children = children;
        this.outputConverter = outputConverter;
        this.source = source;
        this.options = options;
    }

    private static List<DoNode> allowsChildren() {
        return Lists.newArrayList();
    }

    public static <K, V> DoNode createGroupingNode(String name, PGroupedTableType<K, V> ptype) {
        Converter groupingConverter = ptype.getGroupingConverter();
        MapFn fn = groupingConverter.applyPTypeTransforms() ? ptype.getOutputMapFn() : IdentityFn.getInstance();
        return new DoNode(fn, name, ptype, NO_CHILDREN, ptype.getGroupingConverter(), null, null);
    }

    public static DoNode createOutputNode(String name, Converter outputConverter, PType<?> ptype) {
        MapFn fn = outputConverter.applyPTypeTransforms() ? ptype.getOutputMapFn() : IdentityFn.getInstance();
        return new DoNode(fn, name, ptype, NO_CHILDREN, outputConverter, null, null);
    }

    public static DoNode createFnNode(String name, DoFn<?, ?> function, PType<?> ptype, ParallelDoOptions options) {
        return new DoNode(function, name, ptype, DoNode.allowsChildren(), null, null, options);
    }

    public static <S> DoNode createInputNode(Source<S> source) {
        Converter<?, ?, ?, ?> srcConverter = source.getConverter();
        PType<S> ptype = source.getType();
        MapFn fn = srcConverter.applyPTypeTransforms() ? ptype.getInputMapFn() : IdentityFn.getInstance();
        return new DoNode(fn, source.toString(), ptype, DoNode.allowsChildren(), null, source, null);
    }

    public boolean isOutputNode() {
        return this.outputConverter != null;
    }

    public String getName() {
        return this.name;
    }

    public List<DoNode> getChildren() {
        return this.children;
    }

    public Source<?> getSource() {
        return this.source;
    }

    public PType<?> getPType() {
        return this.ptype;
    }

    public DoNode addChild(DoNode node) {
        boolean exists = false;
        for (DoNode child : this.children) {
            if (node != child && (!node.isOutputNode() || !node.equals(child))) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.children.add(node);
        }
        return this;
    }

    public void setOutputName(String outputName) {
        if (this.outputConverter == null) {
            throw new IllegalStateException("Cannot set output name w/o output converter: " + outputName);
        }
        this.outputName = outputName;
    }

    public RTNode toRTNode(boolean inputNode, Configuration conf, NodeContext nodeContext) {
        ArrayList childRTNodes = Lists.newArrayList();
        if (this.options != null) {
            this.options.configure(conf);
        }
        this.fn.configure(conf);
        for (DoNode child : this.children) {
            childRTNodes.add(child.toRTNode(false, conf, nodeContext));
        }
        Converter inputConverter = null;
        if (inputNode) {
            inputConverter = nodeContext == NodeContext.MAP ? this.source.getConverter() : ((PGroupedTableType)this.ptype).getGroupingConverter();
        }
        return new RTNode(this.fn, this.getPType(), this.name, childRTNodes, inputConverter, this.outputConverter, this.outputName);
    }

    public boolean equals(Object other) {
        if (!(other instanceof DoNode)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        DoNode o = (DoNode)other;
        return this.name.equals(o.name) && this.fn.equals(o.fn) && this.source == o.source && this.outputConverter == o.outputConverter;
    }

    public int hashCode() {
        HashCodeBuilder hcb = new HashCodeBuilder();
        return hcb.append((Object)this.name).append((Object)this.fn).append(this.source).append((Object)this.outputConverter).toHashCode();
    }
}

