/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.exec;

import java.io.IOException;
import java.util.Map;
import org.apache.crunch.hadoop.mapreduce.lib.jobcontrol.CrunchControlledJob;
import org.apache.crunch.io.PathTarget;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public final class CrunchJobHooks {
    private CrunchJobHooks() {
    }

    public static final class CompletionHook
    implements CrunchControlledJob.Hook {
        private final Job job;
        private final Path workingPath;
        private final Map<Integer, PathTarget> multiPaths;
        private final boolean mapOnlyJob;

        public CompletionHook(Job job, Path workingPath, Map<Integer, PathTarget> multiPaths, boolean mapOnlyJob) {
            this.job = job;
            this.workingPath = workingPath;
            this.multiPaths = multiPaths;
            this.mapOnlyJob = mapOnlyJob;
        }

        @Override
        public void run() throws IOException {
            this.handleMultiPaths();
        }

        private synchronized void handleMultiPaths() throws IOException {
            try {
                if (this.job.isSuccessful() && !this.multiPaths.isEmpty()) {
                    for (Map.Entry<Integer, PathTarget> entry : this.multiPaths.entrySet()) {
                        entry.getValue().handleOutputs(this.job.getConfiguration(), this.workingPath, entry.getKey());
                    }
                }
            }
            catch (Exception ie) {
                throw new IOException(ie);
            }
        }
    }

    public static final class PrepareHook
    implements CrunchControlledJob.Hook {
        private final Job job;

        public PrepareHook(Job job) {
            this.job = job;
        }

        @Override
        public void run() throws IOException {
            Configuration conf = this.job.getConfiguration();
            if (conf.getBoolean("mapreduce.jobcontrol.createdir.ifnotexist", false)) {
                Path[] inputPaths;
                for (Path inputPath : inputPaths = FileInputFormat.getInputPaths((JobContext)this.job)) {
                    FileSystem fs = inputPath.getFileSystem(conf);
                    if (fs.exists(inputPath)) continue;
                    try {
                        fs.mkdirs(inputPath);
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

