/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.emit;

import java.io.IOException;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.Emitter;
import org.apache.crunch.types.Converter;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;

public class OutputEmitter<T, K, V>
implements Emitter<T> {
    private final Converter<K, V, Object, Object> converter;
    private final TaskInputOutputContext<?, ?, K, V> context;

    public OutputEmitter(Converter<K, V, Object, Object> converter, TaskInputOutputContext<?, ?, K, V> context) {
        this.converter = converter;
        this.context = context;
    }

    @Override
    public void emit(T emitted) {
        try {
            K key = this.converter.outputKey(emitted);
            V value = this.converter.outputValue(emitted);
            this.context.write(key, value);
        }
        catch (IOException e) {
            throw new CrunchRuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new CrunchRuntimeException(e);
        }
    }

    @Override
    public void flush() {
    }
}

