/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mr.emit;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.crunch.Emitter;
import org.apache.crunch.impl.mr.run.RTNode;
import org.apache.crunch.types.PType;
import org.apache.hadoop.conf.Configuration;

public class IntermediateEmitter
implements Emitter<Object> {
    private final List<RTNode> children;
    private final PType<Object> outputPType;
    private final boolean needDetachedValues;

    public IntermediateEmitter(PType<Object> outputPType, List<RTNode> children, Configuration conf, boolean disableDeepCopy) {
        this.outputPType = outputPType;
        this.children = ImmutableList.copyOf(children);
        outputPType.initialize(conf);
        this.needDetachedValues = !disableDeepCopy && this.children.size() > 1;
    }

    @Override
    public void emit(Object emitted) {
        for (RTNode child : this.children) {
            Object value = emitted;
            if (this.needDetachedValues) {
                value = this.outputPType.getDetachedValue(emitted);
            }
            child.process(value);
        }
    }

    @Override
    public void flush() {
    }
}

