/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mem.emit;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.crunch.Emitter;

public class InMemoryEmitter<T>
implements Emitter<T> {
    private final List<T> output;

    public static <T> InMemoryEmitter<T> create() {
        return new InMemoryEmitter<T>();
    }

    public InMemoryEmitter() {
        this(Lists.newArrayList());
    }

    public InMemoryEmitter(List<T> output) {
        this.output = output;
    }

    @Override
    public void emit(T emitted) {
        this.output.add(emitted);
    }

    @Override
    public void flush() {
        this.output.clear();
    }

    public List<T> getOutput() {
        return this.output;
    }
}

