/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mem.collect;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.crunch.GroupingOptions;
import org.apache.crunch.Pair;
import org.apache.crunch.Pipeline;
import org.apache.crunch.impl.SingleUseIterable;
import org.apache.crunch.types.PType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.ReflectionUtils;

abstract class Shuffler<K, V>
implements Iterable<Pair<K, Iterable<V>>> {
    Shuffler() {
    }

    public abstract void add(Pair<K, V> var1);

    private static <K, V> Map<K, V> getMapForKeyType(PType<?> ptype) {
        if (ptype != null && Comparable.class.isAssignableFrom(ptype.getTypeClass())) {
            return new TreeMap();
        }
        return Maps.newHashMap();
    }

    public static <S, T> Shuffler<S, T> create(PType<S> keyType, GroupingOptions options, Pipeline pipeline) {
        Map map = Shuffler.getMapForKeyType(keyType);
        if (options != null) {
            Job job;
            try {
                job = new Job(pipeline.getConfiguration());
            }
            catch (IOException e) {
                throw new IllegalStateException("Could not create Job instance", e);
            }
            options.configure(job);
            if (Pair.class.equals(keyType.getTypeClass()) && options.getGroupingComparatorClass() != null) {
                PType pairKey = keyType.getSubTypes().get(0);
                return new SecondarySortShuffler(Shuffler.getMapForKeyType(pairKey));
            }
            if (options.getSortComparatorClass() != null) {
                RawComparator rc = (RawComparator)ReflectionUtils.newInstance(options.getSortComparatorClass(), (Configuration)job.getConfiguration());
                map = new TreeMap((Comparator<Object>)rc);
                return new MapShuffler(map, keyType);
            }
        }
        return new MapShuffler(map);
    }

    private static class SecondarySortShuffler<K, SK, V>
    extends Shuffler<Pair<K, SK>, V> {
        private Map<K, List<Pair<SK, V>>> map;

        public SecondarySortShuffler(Map<K, List<Pair<SK, V>>> map) {
            this.map = map;
        }

        @Override
        public Iterator<Pair<Pair<K, SK>, Iterable<V>>> iterator() {
            return Iterators.transform(this.map.entrySet().iterator(), new SSFunction());
        }

        @Override
        public void add(Pair<Pair<K, SK>, V> record) {
            K primary = record.first().first();
            if (!this.map.containsKey(primary)) {
                this.map.put(primary, Lists.newArrayList());
            }
            this.map.get(primary).add(Pair.of(record.first().second(), record.second()));
        }
    }

    private static class SSFunction<K, SK, V>
    implements Function<Map.Entry<K, List<Pair<SK, V>>>, Pair<Pair<K, SK>, Iterable<V>>> {
        private SSFunction() {
        }

        public Pair<Pair<K, SK>, Iterable<V>> apply(Map.Entry<K, List<Pair<SK, V>>> input) {
            List<Pair<SK, V>> values = input.getValue();
            Collections.sort(values, new Comparator<Pair<SK, V>>(){

                @Override
                public int compare(Pair<SK, V> o1, Pair<SK, V> o2) {
                    return ((Comparable)o1.first()).compareTo(o2.first());
                }
            });
            Pair<K, SK> key = Pair.of(input.getKey(), values.get(0).first());
            return Pair.of(key, Iterables.transform(values, (Function)new Function<Pair<SK, V>, V>(){

                public V apply(Pair<SK, V> input) {
                    return input.second();
                }
            }));
        }
    }

    private static class MapShuffler<K, V>
    extends Shuffler<K, V> {
        private final Map<Object, Collection<V>> map;
        private final PType<K> keyType;

        public MapShuffler(Map<Object, Collection<V>> map) {
            this(map, null);
        }

        public MapShuffler(Map<Object, Collection<V>> map, PType<K> keyType) {
            this.map = map;
            this.keyType = keyType;
        }

        @Override
        public Iterator<Pair<K, Iterable<V>>> iterator() {
            return Iterators.transform(this.map.entrySet().iterator(), new HFunction(this.keyType));
        }

        @Override
        public void add(Pair<K, V> record) {
            K key = record.first();
            if (this.keyType != null) {
                key = this.keyType.getConverter().outputKey(this.keyType.getOutputMapFn().map(key));
            }
            if (!this.map.containsKey(key)) {
                ArrayList values = Lists.newArrayList();
                this.map.put(key, values);
            }
            this.map.get(key).add(record.second());
        }
    }

    private static class HFunction<K, V>
    implements Function<Map.Entry<Object, Collection<V>>, Pair<K, Iterable<V>>> {
        private final PType<K> keyType;

        public HFunction(PType<K> keyType) {
            this.keyType = keyType;
        }

        public Pair<K, Iterable<V>> apply(Map.Entry<Object, Collection<V>> input) {
            Object key;
            if (this.keyType == null) {
                key = input.getKey();
            } else {
                Object k = this.keyType.getConverter().convertInput(input.getKey(), null);
                key = this.keyType.getInputMapFn().map(k);
            }
            return Pair.of(key, new SingleUseIterable((Iterable)input.getValue()));
        }
    }
}

