/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.mem;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.CounterGroup;
import org.apache.hadoop.mapreduce.Counters;
import org.apache.hadoop.mapreduce.counters.AbstractCounters;

class CountersWrapper
extends Counters {
    private Counters active;
    private final Map<String, Map<String, Counter>> lookupCache = Maps.newHashMap();
    private Set<Counters> allCounters = Sets.newHashSet();

    CountersWrapper() {
        this.active = new Counters();
        this.allCounters.add(this.active);
    }

    CountersWrapper(org.apache.hadoop.mapred.Counters counters) {
        this.active = new Counters((AbstractCounters)counters);
        this.allCounters.add(this.active);
    }

    public Counter findCounter(String groupName, String counterName) {
        Counter counter;
        HashMap c = this.lookupCache.get(groupName);
        if (c == null) {
            c = Maps.newHashMap();
            this.lookupCache.put(groupName, c);
        }
        if ((counter = (Counter)c.get(counterName)) == null) {
            try {
                counter = this.active.findCounter(groupName, counterName);
            }
            catch (Exception e) {
                this.active = new Counters();
                this.allCounters.add(this.active);
                counter = this.active.findCounter(groupName, counterName);
            }
            c.put(counterName, counter);
        }
        return counter;
    }

    public synchronized Counter findCounter(Enum<?> key) {
        return this.findCounter(key.getClass().getName(), key.name());
    }

    public synchronized Collection<String> getGroupNames() {
        return this.lookupCache.keySet();
    }

    public Iterator<CounterGroup> iterator() {
        return Iterators.concat(Iterables.transform(this.allCounters, (Function)new Function<Counters, Iterator<CounterGroup>>(){

            public Iterator<CounterGroup> apply(@Nullable Counters input) {
                return input.iterator();
            }
        }).iterator());
    }

    public synchronized CounterGroup getGroup(String groupName) {
        if (this.allCounters.size() == 1) {
            return (CounterGroup)this.active.getGroup(groupName);
        }
        throw new UnsupportedOperationException("CounterWrapper cannot return CounterGroup when there are too many Counters");
    }

    public synchronized void write(DataOutput out) throws IOException {
        throw new UnsupportedOperationException("CountersWrapper may not be written");
    }

    public synchronized void readFields(DataInput in) throws IOException {
        throw new UnsupportedOperationException("CountersWrapper may not be read");
    }

    public synchronized int countCounters() {
        int cntrs = 0;
        for (Counters c : this.allCounters) {
            cntrs += c.countCounters();
        }
        return cntrs;
    }

    public synchronized void incrAllCounters(Counters other) {
        for (CounterGroup cg : other) {
            for (Counter c : cg) {
                this.findCounter(cg.getName(), c.getName()).increment(c.getValue());
            }
        }
    }
}

