/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.dist.collect;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.crunch.CachingOptions;
import org.apache.crunch.FilterFn;
import org.apache.crunch.GroupingOptions;
import org.apache.crunch.MapFn;
import org.apache.crunch.PCollection;
import org.apache.crunch.PObject;
import org.apache.crunch.PTable;
import org.apache.crunch.Pair;
import org.apache.crunch.ParallelDoOptions;
import org.apache.crunch.TableSource;
import org.apache.crunch.Target;
import org.apache.crunch.impl.dist.DistributedPipeline;
import org.apache.crunch.impl.dist.collect.BaseGroupedTable;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.lib.Aggregate;
import org.apache.crunch.lib.Cogroup;
import org.apache.crunch.lib.Join;
import org.apache.crunch.lib.PTables;
import org.apache.crunch.materialize.MaterializableMap;
import org.apache.crunch.materialize.pobject.MapPObject;
import org.apache.crunch.types.PType;

public abstract class PTableBase<K, V>
extends PCollectionImpl<Pair<K, V>>
implements PTable<K, V> {
    public PTableBase(String name, DistributedPipeline pipeline) {
        super(name, pipeline);
    }

    public PTableBase(String name, DistributedPipeline pipeline, ParallelDoOptions options) {
        super(name, pipeline, options);
    }

    @Override
    public PType<K> getKeyType() {
        return this.getPTableType().getKeyType();
    }

    @Override
    public PType<V> getValueType() {
        return this.getPTableType().getValueType();
    }

    @Override
    public BaseGroupedTable<K, V> groupByKey() {
        return this.pipeline.getFactory().createGroupedTable(this, GroupingOptions.builder().build());
    }

    @Override
    public BaseGroupedTable<K, V> groupByKey(int numReduceTasks) {
        return this.pipeline.getFactory().createGroupedTable(this, GroupingOptions.builder().numReducers(numReduceTasks).build());
    }

    @Override
    public BaseGroupedTable<K, V> groupByKey(GroupingOptions groupingOptions) {
        return this.pipeline.getFactory().createGroupedTable(this, groupingOptions);
    }

    @Override
    public PTable<K, V> union(PTable<K, V> other) {
        return this.union(new PTable[]{other});
    }

    @Override
    public PTable<K, V> union(PTable<K, V> ... others) {
        ArrayList internal = Lists.newArrayList();
        internal.add(this);
        for (PTable<K, V> table : others) {
            internal.add((PTableBase)table);
        }
        return this.pipeline.getFactory().createUnionTable(internal);
    }

    @Override
    public PTable<K, V> write(Target target) {
        if (this.getMaterializedAt() != null) {
            this.getPipeline().write(this.pipeline.getFactory().createInputTable((TableSource)((Object)this.getMaterializedAt()), this.pipeline, this.doOptions), target);
        } else {
            this.getPipeline().write(this, target);
        }
        return this;
    }

    @Override
    public PTable<K, V> write(Target target, Target.WriteMode writeMode) {
        if (this.getMaterializedAt() != null) {
            this.getPipeline().write(this.pipeline.getFactory().createInputTable((TableSource)((Object)this.getMaterializedAt()), this.pipeline, this.doOptions), target, writeMode);
        } else {
            this.getPipeline().write(this, target, writeMode);
        }
        return this;
    }

    @Override
    public PTable<K, V> cache() {
        return this.cache(CachingOptions.DEFAULT);
    }

    @Override
    public PTable<K, V> cache(CachingOptions options) {
        this.pipeline.cache(this, options);
        return this;
    }

    @Override
    public PTable<K, V> filter(FilterFn<Pair<K, V>> filterFn) {
        return this.parallelDo(filterFn, this.getPTableType());
    }

    @Override
    public PTable<K, V> filter(String name, FilterFn<Pair<K, V>> filterFn) {
        return this.parallelDo(name, filterFn, this.getPTableType());
    }

    @Override
    public <U> PTable<K, U> mapValues(MapFn<V, U> mapFn, PType<U> ptype) {
        return PTables.mapValues(this, mapFn, ptype);
    }

    @Override
    public <U> PTable<K, U> mapValues(String name, MapFn<V, U> mapFn, PType<U> ptype) {
        return PTables.mapValues(name, this, mapFn, ptype);
    }

    @Override
    public <K2> PTable<K2, V> mapKeys(MapFn<K, K2> mapFn, PType<K2> ptype) {
        return PTables.mapKeys(this, mapFn, ptype);
    }

    @Override
    public <K2> PTable<K2, V> mapKeys(String name, MapFn<K, K2> mapFn, PType<K2> ptype) {
        return PTables.mapKeys(name, this, mapFn, ptype);
    }

    @Override
    public PTable<K, V> top(int count) {
        return Aggregate.top(this, count, true);
    }

    @Override
    public PTable<K, V> bottom(int count) {
        return Aggregate.top(this, count, false);
    }

    @Override
    public PTable<K, Collection<V>> collectValues() {
        return Aggregate.collectValues(this);
    }

    @Override
    public <U> PTable<K, Pair<V, U>> join(PTable<K, U> other) {
        return Join.join(this, other);
    }

    @Override
    public <U> PTable<K, Pair<Collection<V>, Collection<U>>> cogroup(PTable<K, U> other) {
        return Cogroup.cogroup(this, other);
    }

    @Override
    public PCollection<K> keys() {
        return PTables.keys(this);
    }

    @Override
    public PCollection<V> values() {
        return PTables.values(this);
    }

    @Override
    public Map<K, V> materializeToMap() {
        return new MaterializableMap(this.materialize());
    }

    @Override
    public PObject<Map<K, V>> asMap() {
        return new MapPObject(this);
    }
}

