/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.dist.collect;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.crunch.Aggregator;
import org.apache.crunch.CachingOptions;
import org.apache.crunch.CrunchRuntimeException;
import org.apache.crunch.DoFn;
import org.apache.crunch.FilterFn;
import org.apache.crunch.MapFn;
import org.apache.crunch.PCollection;
import org.apache.crunch.PObject;
import org.apache.crunch.PTable;
import org.apache.crunch.Pair;
import org.apache.crunch.ParallelDoOptions;
import org.apache.crunch.PipelineCallable;
import org.apache.crunch.ReadableData;
import org.apache.crunch.SourceTarget;
import org.apache.crunch.Target;
import org.apache.crunch.fn.ExtractKeyFn;
import org.apache.crunch.fn.IdentityFn;
import org.apache.crunch.impl.dist.DistributedPipeline;
import org.apache.crunch.impl.dist.collect.BaseDoCollection;
import org.apache.crunch.impl.dist.collect.BaseDoTable;
import org.apache.crunch.impl.dist.collect.BaseGroupedTable;
import org.apache.crunch.impl.dist.collect.BaseInputCollection;
import org.apache.crunch.impl.dist.collect.BaseUnionCollection;
import org.apache.crunch.io.ReadableSource;
import org.apache.crunch.lib.Aggregate;
import org.apache.crunch.materialize.pobject.CollectionPObject;
import org.apache.crunch.materialize.pobject.FirstElementPObject;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.types.PTypeFamily;

public abstract class PCollectionImpl<S>
implements PCollection<S> {
    private final String name;
    protected DistributedPipeline pipeline;
    private boolean materialized;
    protected SourceTarget<S> materializedAt;
    protected final ParallelDoOptions doOptions;
    private long size = -1L;
    private boolean breakpoint;

    public PCollectionImpl(String name, DistributedPipeline pipeline) {
        this(name, pipeline, ParallelDoOptions.builder().build());
    }

    public PCollectionImpl(String name, DistributedPipeline pipeline, ParallelDoOptions doOptions) {
        this.name = name;
        this.pipeline = pipeline;
        this.doOptions = doOptions;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DistributedPipeline getPipeline() {
        return this.pipeline;
    }

    public ParallelDoOptions getParallelDoOptions() {
        return this.doOptions;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Iterable<S> materialize() {
        if (!this.waitingOnTargets() && this.getSize() == 0L) {
            System.err.println("Materializing an empty PCollection: " + this.getName());
            return Collections.emptyList();
        }
        if (this.materializedAt != null && this.materializedAt instanceof ReadableSource) {
            try {
                return ((ReadableSource)((Object)this.materializedAt)).read(this.getPipeline().getConfiguration());
            }
            catch (IOException e) {
                throw new CrunchRuntimeException("Error reading materialized data", e);
            }
        }
        this.materialized = true;
        return this.pipeline.materialize(this);
    }

    @Override
    public PCollection<S> cache() {
        return this.cache(CachingOptions.DEFAULT);
    }

    @Override
    public PCollection<S> cache(CachingOptions options) {
        this.pipeline.cache(this, options);
        return this;
    }

    @Override
    public PCollection<S> union(PCollection<S> other) {
        return this.union(new PCollection[]{other});
    }

    @Override
    public PCollection<S> union(PCollection<S> ... collections) {
        ArrayList internal = Lists.newArrayList();
        internal.add(this);
        for (PCollection<S> collection : collections) {
            internal.add((PCollectionImpl)collection.parallelDo(IdentityFn.getInstance(), collection.getPType()));
        }
        return this.pipeline.getFactory().createUnionCollection(internal);
    }

    @Override
    public <T> PCollection<T> parallelDo(DoFn<S, T> fn, PType<T> type) {
        return this.parallelDo("S" + this.pipeline.getNextAnonymousStageId(), fn, type);
    }

    @Override
    public <T> PCollection<T> parallelDo(String name, DoFn<S, T> fn, PType<T> type) {
        return this.parallelDo(name, fn, type, ParallelDoOptions.builder().build());
    }

    @Override
    public <T> PCollection<T> parallelDo(String name, DoFn<S, T> fn, PType<T> type, ParallelDoOptions options) {
        return this.pipeline.getFactory().createDoCollection(name, this.getChainingCollection(), fn, type, options);
    }

    @Override
    public <K, V> PTable<K, V> parallelDo(DoFn<S, Pair<K, V>> fn, PTableType<K, V> type) {
        return this.parallelDo("S" + this.pipeline.getNextAnonymousStageId(), fn, type);
    }

    @Override
    public <K, V> PTable<K, V> parallelDo(String name, DoFn<S, Pair<K, V>> fn, PTableType<K, V> type) {
        return this.parallelDo(name, fn, type, ParallelDoOptions.builder().build());
    }

    @Override
    public <K, V> PTable<K, V> parallelDo(String name, DoFn<S, Pair<K, V>> fn, PTableType<K, V> type, ParallelDoOptions options) {
        return this.pipeline.getFactory().createDoTable(name, this.getChainingCollection(), fn, type, options);
    }

    @Override
    public PCollection<S> write(Target target) {
        if (this.materializedAt != null) {
            this.getPipeline().write(this.pipeline.getFactory().createInputCollection(this.materializedAt, this.pipeline, this.doOptions), target);
        } else {
            this.getPipeline().write(this, target);
        }
        return this;
    }

    @Override
    public PCollection<S> write(Target target, Target.WriteMode writeMode) {
        if (this.materializedAt != null) {
            this.getPipeline().write(this.pipeline.getFactory().createInputCollection(this.materializedAt, this.pipeline, this.doOptions), target, writeMode);
        } else {
            this.getPipeline().write(this, target, writeMode);
        }
        return this;
    }

    public void accept(Visitor visitor) {
        if (this.materializedAt != null) {
            visitor.visitInputCollection(this.pipeline.getFactory().createInputCollection(this.materializedAt, this.pipeline, this.doOptions));
        } else {
            this.acceptInternal(visitor);
        }
    }

    protected boolean waitingOnTargets() {
        for (PCollectionImpl<?> parent : this.getParents()) {
            if (!parent.waitingOnTargets()) continue;
            return true;
        }
        return false;
    }

    protected abstract void acceptInternal(Visitor var1);

    public void setBreakpoint() {
        this.breakpoint = true;
    }

    public boolean isBreakpoint() {
        return this.breakpoint;
    }

    @Override
    public PObject<Collection<S>> asCollection() {
        return new CollectionPObject(this);
    }

    @Override
    public PObject<S> first() {
        return new FirstElementPObject(this);
    }

    @Override
    public <Output> Output sequentialDo(String label, PipelineCallable<Output> pipelineCallable) {
        pipelineCallable.dependsOn(label, this);
        return this.getPipeline().sequentialDo(pipelineCallable);
    }

    public SourceTarget<S> getMaterializedAt() {
        return this.materializedAt;
    }

    public void materializeAt(SourceTarget<S> sourceTarget) {
        this.materializedAt = sourceTarget;
        this.size = this.materializedAt.getSize(this.getPipeline().getConfiguration());
    }

    @Override
    public PCollection<S> filter(FilterFn<S> filterFn) {
        return this.parallelDo("Filter with " + filterFn.getClass().getSimpleName(), filterFn, this.getPType());
    }

    @Override
    public PCollection<S> filter(String name, FilterFn<S> filterFn) {
        return this.parallelDo(name, filterFn, this.getPType());
    }

    @Override
    public <K> PTable<K, S> by(MapFn<S, K> mapFn, PType<K> keyType) {
        return this.parallelDo((DoFn)new ExtractKeyFn<K, S>(mapFn), this.getTypeFamily().tableOf(keyType, this.getPType()));
    }

    @Override
    public <K> PTable<K, S> by(String name, MapFn<S, K> mapFn, PType<K> keyType) {
        return this.parallelDo(name, (DoFn)new ExtractKeyFn<K, S>(mapFn), this.getTypeFamily().tableOf(keyType, this.getPType()));
    }

    @Override
    public PTable<S, Long> count() {
        return Aggregate.count(this);
    }

    @Override
    public PObject<Long> length() {
        return Aggregate.length(this);
    }

    @Override
    public PObject<S> max() {
        return Aggregate.max(this);
    }

    @Override
    public PObject<S> min() {
        return Aggregate.min(this);
    }

    @Override
    public PCollection<S> aggregate(Aggregator<S> aggregator) {
        return Aggregate.aggregate(this, aggregator);
    }

    @Override
    public PTypeFamily getTypeFamily() {
        return this.getPType().getFamily();
    }

    public abstract List<PCollectionImpl<?>> getParents();

    public PCollectionImpl<?> getOnlyParent() {
        List<PCollectionImpl<?>> parents = this.getParents();
        if (parents.size() != 1) {
            throw new IllegalArgumentException("Expected exactly one parent PCollection");
        }
        return parents.get(0);
    }

    public Set<Target> getTargetDependencies() {
        HashSet targetDeps = Sets.newHashSet(this.doOptions.getTargets());
        for (PCollectionImpl<?> parent : this.getParents()) {
            targetDeps = Sets.union((Set)targetDeps, parent.getTargetDependencies());
        }
        return targetDeps;
    }

    public int getDepth() {
        int parentMax = 0;
        for (PCollectionImpl<?> parent : this.getParents()) {
            parentMax = Math.max(parent.getDepth(), parentMax);
        }
        return 1 + parentMax;
    }

    @Override
    public ReadableData<S> asReadable(boolean materialize) {
        if (this.materializedAt != null && this.materializedAt instanceof ReadableSource) {
            return ((ReadableSource)((Object)this.materializedAt)).asReadable();
        }
        if (this.materialized || materialize) {
            return this.pipeline.getMaterializeSourceTarget(this).asReadable();
        }
        return this.getReadableDataInternal();
    }

    protected ReadableData<S> materializedData() {
        this.materialized = true;
        return this.pipeline.getMaterializeSourceTarget(this).asReadable();
    }

    protected abstract ReadableData<S> getReadableDataInternal();

    @Override
    public long getSize() {
        if (this.size < 0L) {
            this.size = this.getSizeInternal();
        }
        return this.size;
    }

    protected abstract long getSizeInternal();

    public abstract long getLastModifiedAt();

    protected PCollectionImpl<S> getChainingCollection() {
        return this;
    }

    public static interface Visitor {
        public void visitInputCollection(BaseInputCollection<?> var1);

        public void visitUnionCollection(BaseUnionCollection<?> var1);

        public void visitDoCollection(BaseDoCollection<?> var1);

        public void visitDoTable(BaseDoTable<?, ?> var1);

        public void visitGroupedTable(BaseGroupedTable<?, ?> var1);
    }
}

