/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.dist.collect;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.crunch.Pair;
import org.apache.crunch.ParallelDoOptions;
import org.apache.crunch.ReadableData;
import org.apache.crunch.TableSource;
import org.apache.crunch.impl.dist.DistributedPipeline;
import org.apache.crunch.impl.dist.collect.BaseInputCollection;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.impl.dist.collect.PTableBase;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;

public class BaseInputTable<K, V>
extends PTableBase<K, V> {
    protected final TableSource<K, V> source;
    protected final BaseInputCollection<Pair<K, V>> asCollection;

    public BaseInputTable(TableSource<K, V> source, DistributedPipeline pipeline) {
        super(source.toString(), pipeline);
        this.source = source;
        this.asCollection = pipeline.getFactory().createInputCollection(source, pipeline, ParallelDoOptions.builder().build());
    }

    public BaseInputTable(TableSource<K, V> source, DistributedPipeline pipeline, ParallelDoOptions doOpts) {
        super(source.toString(), pipeline, doOpts);
        this.source = source;
        this.asCollection = pipeline.getFactory().createInputCollection(source, pipeline, doOpts);
    }

    public TableSource<K, V> getSource() {
        return this.source;
    }

    @Override
    protected boolean waitingOnTargets() {
        return this.asCollection.waitingOnTargets();
    }

    @Override
    protected long getSizeInternal() {
        return this.asCollection.getSizeInternal();
    }

    @Override
    public PTableType<K, V> getPTableType() {
        return this.source.getTableType();
    }

    @Override
    public PType<Pair<K, V>> getPType() {
        return this.source.getType();
    }

    @Override
    public List<PCollectionImpl<?>> getParents() {
        return ImmutableList.of();
    }

    @Override
    protected ReadableData<Pair<K, V>> getReadableDataInternal() {
        return this.asCollection.getReadableDataInternal();
    }

    @Override
    public long getLastModifiedAt() {
        return this.source.getLastModifiedAt(this.pipeline.getConfiguration());
    }

    @Override
    protected void acceptInternal(PCollectionImpl.Visitor visitor) {
        visitor.visitInputCollection(this.asCollection);
    }

    public int hashCode() {
        return this.asCollection.hashCode();
    }

    public boolean equals(Object other) {
        return this.asCollection.equals(other);
    }
}

