/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crunch.impl.dist.collect;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.crunch.CombineFn;
import org.apache.crunch.DoFn;
import org.apache.crunch.PTable;
import org.apache.crunch.Pair;
import org.apache.crunch.ParallelDoOptions;
import org.apache.crunch.ReadableData;
import org.apache.crunch.impl.dist.collect.BaseGroupedTable;
import org.apache.crunch.impl.dist.collect.PCollectionImpl;
import org.apache.crunch.impl.dist.collect.PTableBase;
import org.apache.crunch.types.PTableType;
import org.apache.crunch.types.PType;
import org.apache.crunch.util.DelegatingReadableData;

public class BaseDoTable<K, V>
extends PTableBase<K, V>
implements PTable<K, V> {
    private final PCollectionImpl<?> parent;
    protected final DoFn<?, Pair<K, V>> combineFn;
    protected final DoFn<?, Pair<K, V>> fn;
    protected final PTableType<K, V> type;

    private static <S, K, V> CombineFn<K, V> asCombineFn(DoFn<S, Pair<K, V>> fn) {
        if (fn instanceof CombineFn) {
            return (CombineFn)fn;
        }
        return null;
    }

    protected <S> BaseDoTable(String name, PCollectionImpl<S> parent, DoFn<S, Pair<K, V>> fn, PTableType<K, V> ntype, ParallelDoOptions options) {
        this(name, parent, BaseDoTable.asCombineFn(fn), fn, ntype, options);
    }

    protected <S> BaseDoTable(String name, PCollectionImpl<S> parent, CombineFn<K, V> combineFn, DoFn<S, Pair<K, V>> fn, PTableType<K, V> ntype) {
        this(name, parent, combineFn, fn, ntype, ParallelDoOptions.builder().build());
    }

    protected <S> BaseDoTable(String name, PCollectionImpl<S> parent, CombineFn<K, V> combineFn, DoFn<S, Pair<K, V>> fn, PTableType<K, V> ntype, ParallelDoOptions options) {
        super(name, parent.getPipeline(), options);
        this.parent = parent;
        this.combineFn = combineFn;
        this.fn = fn;
        this.type = ntype;
    }

    @Override
    protected long getSizeInternal() {
        return (long)(this.fn.scaleFactor() * (float)this.parent.getSize());
    }

    @Override
    public PTableType<K, V> getPTableType() {
        return this.type;
    }

    @Override
    protected ReadableData<Pair<K, V>> getReadableDataInternal() {
        if (this.getOnlyParent() instanceof BaseGroupedTable) {
            return this.materializedData();
        }
        return new DelegatingReadableData(this.getOnlyParent().asReadable(false), this.fn);
    }

    @Override
    public PType<Pair<K, V>> getPType() {
        return this.type;
    }

    @Override
    public List<PCollectionImpl<?>> getParents() {
        return ImmutableList.of(this.parent);
    }

    @Override
    public long getLastModifiedAt() {
        return this.parent.getLastModifiedAt();
    }

    @Override
    protected void acceptInternal(PCollectionImpl.Visitor visitor) {
        visitor.visitDoTable(this);
    }
}

